/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.mail.smime.SMIMEAuthEnveloped;
import org.bouncycastle.mail.smime.SMIMEAuthEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;

public class SMIMEEnvelopedUtil {
    private static Set<ASN1ObjectIdentifier> authOIDs = new HashSet<ASN1ObjectIdentifier>();

    public static RecipientInformationStore getRecipientInfos(MimeBodyPart message) throws MessagingException, CMSException {
        if (message.getContentType().equals("application/pkcs7-mime; name=\"smime.p7m\"; smime-type=authEnveloped-data")) {
            return new SMIMEAuthEnveloped(message).getRecipientInfos();
        }
        return new SMIMEEnveloped(message).getRecipientInfos();
    }

    public static SMIMEEnvelopedGenerator createGenerator(ASN1ObjectIdentifier algorithm) {
        if (authOIDs.contains(algorithm)) {
            return new SMIMEAuthEnvelopedGenerator();
        }
        return new SMIMEEnvelopedGenerator();
    }

    static {
        authOIDs.add(NISTObjectIdentifiers.id_aes128_GCM);
        authOIDs.add(NISTObjectIdentifiers.id_aes128_GCM);
        authOIDs.add(NISTObjectIdentifiers.id_aes128_GCM);
    }
}

