/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.examples;

import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.Store;

public class CreateSignedMail {
    static int serialNo = 1;

    static AuthorityKeyIdentifier createAuthorityKeyId(PublicKey pub) throws IOException {
        SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)pub.getEncoded());
        return new AuthorityKeyIdentifier(info);
    }

    static SubjectKeyIdentifier createSubjectKeyId(PublicKey pub) throws IOException {
        SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)pub.getEncoded());
        return new BcX509ExtensionUtils().createSubjectKeyIdentifier(info);
    }

    static X509Certificate makeCertificate(KeyPair subKP, String subDN, KeyPair issKP, String issDN) throws GeneralSecurityException, IOException, OperatorCreationException {
        PublicKey subPub = subKP.getPublic();
        PrivateKey issPriv = issKP.getPrivate();
        PublicKey issPub = issKP.getPublic();
        JcaX509v3CertificateBuilder v3CertGen = new JcaX509v3CertificateBuilder(new X500Name(issDN), BigInteger.valueOf(serialNo++), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 8640000000L), new X500Name(subDN), subPub);
        v3CertGen.addExtension(X509Extension.subjectKeyIdentifier, false, (ASN1Encodable)CreateSignedMail.createSubjectKeyId(subPub));
        v3CertGen.addExtension(X509Extension.authorityKeyIdentifier, false, (ASN1Encodable)CreateSignedMail.createAuthorityKeyId(issPub));
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(v3CertGen.build(new JcaContentSignerBuilder("MD5withRSA").setProvider("BC").build(issPriv)));
    }

    public static void main(String[] args) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
        kpg.initialize(1024, new SecureRandom());
        String signDN = "O=Bouncy Castle, C=AU";
        KeyPair signKP = kpg.generateKeyPair();
        X509Certificate signCert = CreateSignedMail.makeCertificate(signKP, signDN, signKP, signDN);
        String origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
        KeyPair origKP = kpg.generateKeyPair();
        X509Certificate origCert = CreateSignedMail.makeCertificate(origKP, origDN, signKP, signDN);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(origCert);
        certList.add(signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
        SMIMECapabilityVector caps = new SMIMECapabilityVector();
        caps.addCapability(SMIMECapability.dES_EDE3_CBC);
        caps.addCapability(SMIMECapability.rC2_CBC, 128);
        caps.addCapability(SMIMECapability.dES_CBC);
        signedAttrs.add((ASN1Encodable)new SMIMECapabilitiesAttribute(caps));
        IssuerAndSerialNumber issAndSer = new IssuerAndSerialNumber(new X500Name(signDN), origCert.getSerialNumber());
        signedAttrs.add((ASN1Encodable)new SMIMEEncryptionKeyPreferenceAttribute(issAndSer));
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build("SHA1withRSA", origKP.getPrivate(), origCert));
        gen.addCertificates((Store)certs);
        MimeBodyPart msg = new MimeBodyPart();
        msg.setText("Hello world!");
        MimeMultipart mm = gen.generate(msg);
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        InternetAddress fromUser = new InternetAddress("\"Eric H. Echidna\"<eric@bouncycastle.org>");
        InternetAddress toUser = new InternetAddress("example@bouncycastle.org");
        MimeMessage body = new MimeMessage(session);
        body.setFrom((Address)fromUser);
        body.setRecipient(Message.RecipientType.TO, (Address)toUser);
        body.setSubject("example signed message");
        body.setContent((Object)mm, mm.getContentType());
        body.saveChanges();
        body.writeTo((OutputStream)new FileOutputStream("signed.message"));
    }
}

