/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.entropy.util;

import org.bouncycastle.entropy.provider.BouncyCastleEntropyProvider;
import org.bouncycastle.entropy.provider.EntropyProviderInfo;
import org.bouncycastle.entropy.provider.EntropyProviderStatus;
import org.bouncycastle.entropy.util.Hex;
import org.bouncycastle.entropy.util.Strings;

public class DumpInfo {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            if (stringArray[0].equals("-c")) {
                System.out.println(Strings.fromByteArray(Hex.encode(EntropyProviderStatus.getModuleHMAC())));
                System.err.println("Generated new HMAC");
            } else {
                System.err.println("Invalid command line arguments.");
            }
        } else {
            DumpInfo.printInfo();
        }
    }

    public static void printInfo() throws Exception {
        System.out.println(BouncyCastleEntropyProvider.getInfoString());
        System.out.println("Is Ready: " + EntropyProviderStatus.isReady());
        System.out.println("Fips Status Message: " + EntropyProviderStatus.getStatusMessage());
        System.out.println();
        if (EntropyProviderInfo.hasJitterRNG()) {
            System.out.println("--------------------------------------------------------------------------------");
            System.out.println("Jitter Supported:");
            System.out.println("    Load Status:                     " + EntropyProviderInfo.loaderStatus());
            System.out.println("    Load Variant:                    " + EntropyProviderInfo.loadedVariant());
            System.out.println("    Loaded Compiler Major Version:   " + EntropyProviderInfo.loadedCompilerMajorVersion());
            System.out.println("    Native Compiler Info:            " + EntropyProviderInfo.nativeCompilerInfo());
            System.out.println("    Native Build Timestamp:          " + EntropyProviderInfo.nativeBuildTimeStamp());
            System.out.println("    Jitter Lib Version:              " + EntropyProviderInfo.jitterLibVersion());
            System.out.println("--------------------------------------------------------------------------------");
        } else {
            System.out.println("Jitter Not Supported");
            System.out.println("    Load Status:                     " + EntropyProviderInfo.loaderStatus());
        }
        System.out.println("\nModule Checksum:");
        System.out.println(Hex.toHexString(EntropyProviderStatus.getModuleHMAC()));
    }
}

