/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.entropy.util;

public final class Arrays {
    private Arrays() {
    }

    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        return java.util.Arrays.equals(byArray, byArray2);
    }

    public static boolean constantTimeAreEqual(byte[] byArray, byte[] byArray2) {
        int n;
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray == byArray2) {
            return true;
        }
        int n2 = byArray.length < byArray2.length ? byArray.length : byArray2.length;
        int n3 = byArray.length ^ byArray2.length;
        for (n = 0; n != n2; ++n) {
            n3 |= byArray[n] ^ byArray2[n];
        }
        for (n = n2; n < byArray2.length; ++n) {
            n3 |= byArray2[n] ^ ~byArray2[n];
        }
        return n3 == 0;
    }

    public static void fill(byte[] byArray, byte by) {
        java.util.Arrays.fill(byArray, by);
    }

    public static void fill(byte[] byArray, int n, byte by) {
        Arrays.fill(byArray, n, byArray.length, by);
    }

    public static void fill(byte[] byArray, int n, int n2, byte by) {
        java.util.Arrays.fill(byArray, n, n2, by);
    }

    public static byte[] clone(byte[] byArray) {
        return null == byArray ? null : (byte[])byArray.clone();
    }

    public static byte[] copyOfRange(byte[] byArray, int n, int n2) {
        int n3 = Arrays.getLength(n, n2);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, Math.min(byArray.length - n, n3));
        return byArray2;
    }

    private static int getLength(int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            StringBuffer stringBuffer = new StringBuffer(n);
            stringBuffer.append(" > ").append(n2);
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        return n3;
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2) {
        if (null == byArray) {
            return Arrays.clone(byArray2);
        }
        if (null == byArray2) {
            return Arrays.clone(byArray);
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (null == byArray) {
            return Arrays.concatenate(byArray2, byArray3);
        }
        if (null == byArray2) {
            return Arrays.concatenate(byArray, byArray3);
        }
        if (null == byArray3) {
            return Arrays.concatenate(byArray, byArray2);
        }
        byte[] byArray4 = new byte[byArray.length + byArray2.length + byArray3.length];
        int n = 0;
        System.arraycopy(byArray, 0, byArray4, n, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, n += byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, n += byArray2.length, byArray3.length);
        return byArray4;
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        if (null == byArray) {
            return Arrays.concatenate(byArray2, byArray3, byArray4);
        }
        if (null == byArray2) {
            return Arrays.concatenate(byArray, byArray3, byArray4);
        }
        if (null == byArray3) {
            return Arrays.concatenate(byArray, byArray2, byArray4);
        }
        if (null == byArray4) {
            return Arrays.concatenate(byArray, byArray2, byArray3);
        }
        byte[] byArray5 = new byte[byArray.length + byArray2.length + byArray3.length + byArray4.length];
        int n = 0;
        System.arraycopy(byArray, 0, byArray5, n, byArray.length);
        System.arraycopy(byArray2, 0, byArray5, n += byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray5, n += byArray2.length, byArray3.length);
        System.arraycopy(byArray4, 0, byArray5, n += byArray3.length, byArray4.length);
        return byArray5;
    }
}

