/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.entropy.provider;

import org.bouncycastle.entropy.provider.Digest;
import org.bouncycastle.entropy.provider.EntropyProviderOperationException;
import org.bouncycastle.entropy.provider.LongDigest;
import org.bouncycastle.entropy.util.Arrays;
import org.bouncycastle.entropy.util.Hex;
import org.bouncycastle.entropy.util.Pack;
import org.bouncycastle.entropy.util.Strings;

class SHA512Digest
extends LongDigest
implements Digest {
    private static final int DIGEST_LENGTH = 64;

    public SHA512Digest() {
    }

    public SHA512Digest(SHA512Digest sHA512Digest) {
        super(sHA512Digest);
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-512";
    }

    @Override
    public int getDigestSize() {
        return 64;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        this.finish();
        Pack.longToBigEndian(this.H1, byArray, n);
        Pack.longToBigEndian(this.H2, byArray, n + 8);
        Pack.longToBigEndian(this.H3, byArray, n + 16);
        Pack.longToBigEndian(this.H4, byArray, n + 24);
        Pack.longToBigEndian(this.H5, byArray, n + 32);
        Pack.longToBigEndian(this.H6, byArray, n + 40);
        Pack.longToBigEndian(this.H7, byArray, n + 48);
        Pack.longToBigEndian(this.H8, byArray, n + 56);
        this.reset();
        return 64;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = 7640891576956012808L;
        this.H2 = -4942790177534073029L;
        this.H3 = 4354685564936845355L;
        this.H4 = -6534734903238641935L;
        this.H5 = 5840696475078001361L;
        this.H6 = -7276294671716946913L;
        this.H7 = 2270897969802886507L;
        this.H8 = 6620516959819538809L;
    }

    static void selfTest() throws EntropyProviderOperationException {
        SHA512Digest.startUpTest();
    }

    private static void startUpTest() throws EntropyProviderOperationException {
        byte[] byArray = Strings.toByteArray("abc");
        SHA512Digest sHA512Digest = new SHA512Digest();
        sHA512Digest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[sHA512Digest.getDigestSize()];
        sHA512Digest.doFinal(byArray2, 0);
        sHA512Digest.reset();
        if (!Arrays.areEqual(byArray2, Hex.decode("ddaf35a193617abacc417349ae20413112e6fa4e89a97ea20a9eeee64b55d39a2192992a274fc1a836ba3c23a3feebbd454d4423643ce80e2a9ac94fa54ca49f"))) {
            throw new EntropyProviderOperationException("SHA512 KAT Test failed");
        }
    }
}

