/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.entropy.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.entropy.provider.LoaderUtils;
import org.bouncycastle.entropy.provider.Properties;
import org.bouncycastle.entropy.util.Strings;

class Loader {
    private static final Logger LOG = Logger.getLogger(Loader.class.getName());
    private static boolean libsAvailableForSystem = false;
    private static boolean libsInstalled = false;
    private static String statusMessage = "JEnt load not attempted";
    private static boolean loadAttempted = false;
    private static String loadedVariant = "none";
    private static final String JITTER_LOAD_ENABLED = "org.bouncycastle.jent.enabled";
    private static String loadedCompilerMajorVersion = "none";
    private static final String FIXED_INSTALL_DIR = "org.bouncycastle.jent.loader.install_dir";
    private static boolean skipInstallIfSame = false;

    Loader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static synchronized void loadNativeLib() {
        FileLock fileLock;
        String string;
        String string2;
        block46: {
            if (loadAttempted) {
                return;
            }
            loadAttempted = true;
            String string3 = Properties.getPropertyValue(JITTER_LOAD_ENABLED, "true");
            LOG.setLevel(Level.FINE);
            LOG.log(Level.FINE, "jent loader start");
            if ("false".equals(string3)) {
                statusMessage = "jitterng is disabled and not loaded";
                loadedVariant = "none";
                libsInstalled = false;
                loadAttempted = false;
                LOG.log(Level.FINE, statusMessage);
                return;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "examining properties to determine platform and architecture");
            }
            String string4 = Strings.toLowerCase(Properties.getPropertyValue("os.arch", ""));
            String string5 = Strings.toLowerCase(Properties.getPropertyValue("os.name", ""));
            string2 = null;
            string = null;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "host ARCH: " + string4);
                LOG.log(Level.FINE, "host OS: " + string5);
            }
            if (string5.contains("linux")) {
                string2 = "linux";
            } else if (string5.contains("mac") || string5.contains("darwin")) {
                string2 = "darwin";
            }
            if (string2 == null) {
                statusMessage = "OS '" + string5 + "' is not supported.";
                LOG.fine("exited with " + statusMessage);
                return;
            }
            if (string4.contains("x86") || string4.contains("amd") && string4.contains("64")) {
                string = "x86_64";
            } else if (string4.contains("aarch64")) {
                string = "arm64";
            }
            if (string == null) {
                statusMessage = "architecture '" + string4 + "' is not supported";
                LOG.fine("exited with " + statusMessage);
                return;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "derived native platform: " + string2);
                LOG.log(Level.FINE, "derived native architecture: " + string);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "begin determining path to install native libraries");
            }
            String string6 = Properties.getPropertyValue(FIXED_INSTALL_DIR);
            File file = null;
            try {
                if (string6 != null) {
                    file = LoaderUtils.createVersionedTempDir(string6, "1.3.6");
                    skipInstallIfSame = true;
                } else {
                    file = LoaderUtils.createTempDir("bc-jent-jni");
                }
            }
            catch (Exception exception) {
                libsInstalled = false;
                statusMessage = "failed, unable to creat installation directory" + exception.getMessage();
                LOG.fine("exited with " + statusMessage);
            }
            if (file == null) {
                return;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "jent library install location: " + file.getAbsolutePath());
            }
            String string7 = String.format("/native/%s/%s/jent", string2, string);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "begin install probe library from: " + string7);
            }
            File file2 = new File(file, "bc-rng-java.lock");
            FileOutputStream fileOutputStream = null;
            fileLock = null;
            try {
                fileOutputStream = new FileOutputStream(file2);
                fileLock = fileOutputStream.getChannel().lock();
                Versions versions = new Versions(string7);
                String[] stringArray = new String[]{versions.jitterLib, System.mapLibraryName("bcjent-jent")};
                boolean bl = false;
                for (String string8 : versions.versions) {
                    try {
                        LOG.fine("Attempting to load build version: " + string8);
                        Loader.installLibrarySet(string7 + "/" + string8, stringArray, file);
                        bl = true;
                        loadedCompilerMajorVersion = string8;
                        LOG.fine("Load of build version: " + string8 + " was successful");
                        break;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        LOG.fine("UnsatisfiedLinkError for version: " + string8 + " " + unsatisfiedLinkError.getMessage());
                    }
                }
                if (!bl) {
                    throw new Exception("no build version was loadable for this system");
                }
                if (fileOutputStream == null) break block46;
            }
            catch (Throwable throwable) {
                try {
                    statusMessage = "native capabilities lib failed to load " + throwable.getMessage();
                    libsInstalled = false;
                    LOG.fine("exited with " + statusMessage);
                    return;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (fileLock != null) {
                        try {
                            fileLock.release();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fileLock != null) {
            try {
                fileLock.release();
            }
            catch (Exception exception) {}
        }
        libsAvailableForSystem = true;
        statusMessage = "successfully loaded";
        libsInstalled = true;
        loadedVariant = string + "_" + string2;
        if (!LOG.isLoggable(Level.FINE)) return;
        LOG.log(Level.FINE, statusMessage);
        LOG.fine("native loader has finished");
    }

    public static boolean isLibsAvailableForSystem() {
        return libsAvailableForSystem;
    }

    public static boolean isLibsInstalled() {
        return libsInstalled;
    }

    public static boolean isLoadAttempted() {
        return loadAttempted;
    }

    public static String getLoadedVariant() {
        return loadedVariant;
    }

    public static String getLoadedCompilerMajorVersion() {
        return loadedCompilerMajorVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNativeJEntInstalled() {
        Class<Loader> clazz = Loader.class;
        synchronized (Loader.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return libsInstalled;
        }
    }

    private static void installLibrarySet(String string, String[] stringArray, File file) throws Exception {
        try {
            for (String string2 : stringArray) {
                final File file2 = LoaderUtils.extractFromClasspath(file, string + "/" + string2, string2);
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        System.load(file2.getAbsolutePath());
                        return new Object();
                    }
                });
            }
        }
        catch (Throwable throwable) {
            if (!skipInstallIfSame) {
                Loader.delete(file);
            }
            throw throwable;
        }
    }

    private static void delete(File file) {
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                Loader.delete(file2);
            }
        }
        file.delete();
    }

    public static String getStatusMessage() {
        return statusMessage;
    }

    private static class Versions {
        public final String jitterLib;
        public final String[] versions;

        public Versions(String string) throws Exception {
            String string2;
            InputStream inputStream = Loader.class.getResourceAsStream(string + "/versions.txt");
            if (inputStream == null) {
                throw new Exception("versions.txt not found in " + string);
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.jitterLib = bufferedReader.readLine();
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string2 = bufferedReader.readLine()) != null && !string2.equals(".")) {
                arrayList.add(string2.trim());
            }
            this.versions = arrayList.toArray(new String[0]);
        }
    }
}

