/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.entropy.provider;

import java.util.function.Consumer;
import java.util.logging.Level;
import org.bouncycastle.entropy.provider.BouncyCastleEntropyProvider;
import org.bouncycastle.entropy.provider.EntropyProviderOperationException;
import org.bouncycastle.entropy.provider.EntropyProviderStatus;
import org.bouncycastle.entropy.provider.EntropySource;
import org.bouncycastle.entropy.provider.Loader;
import org.bouncycastle.entropy.provider.NativeReference;
import org.bouncycastle.entropy.provider.Properties;

class JitterEntropySource
implements EntropySource {
    static final String OVERSAMPLE_PROP_NAME = "org.bouncycastle.jent.oversample";
    static final String MEMORY_ORDINAL_PROP_NAME = "org.bouncycastle.jent.memorysize_ordinal";
    static final String FIPS_MODE_OFF_PROP_NAME = "org.bouncycastle.jent.fips_off";
    static final String RESTART_LIMIT_PROP_NAME = "org.bouncycastle.jent.restart_limit";
    private static final Object jentLock;
    private static boolean startCalled;
    private static boolean initCalled;
    private static JentRef ref;
    private static String errorMessage;
    private static int memorySizeOrdinal;
    private static int overSampleRate;
    private static boolean fipsMode;
    private static int restartLimit;
    private static Consumer<String> errorStateConsumer;
    private static final int DEFAULT_RETRY_LIMIT = 8;
    private final int byteSize;

    JitterEntropySource() {
        this.byteSize = 32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JitterEntropySource(int n) {
        this.byteSize = n >> 3;
        Object object = jentLock;
        synchronized (object) {
            if (errorMessage != null) {
                throw new IllegalStateException(errorMessage);
            }
            if (!startCalled) {
                int n2;
                startCalled = true;
                JitterEntropySource.loadSettings();
                if (BouncyCastleEntropyProvider.LOG.isLoggable(Level.FINE)) {
                    BouncyCastleEntropyProvider.LOG.fine(String.format("memory size ordinal: %d, over sample rate: %d, FIPS mode: %b", memorySizeOrdinal, overSampleRate, fipsMode));
                }
                if ((n2 = overSampleRate) < 0) {
                    n2 = JitterEntropySource.minOverSample();
                }
                try {
                    ref = new JentRef(JitterEntropySource.allocJitter(memorySizeOrdinal, n2, fipsMode));
                }
                catch (Error error) {
                    EntropyProviderStatus.moveToErrorStatus(error.getMessage());
                    throw error;
                }
            }
        }
    }

    @Override
    public boolean isPredictionResistant() {
        return true;
    }

    @Override
    public byte[] getEntropy() {
        byte[] byArray = new byte[this.byteSize];
        long l = this.getRandomBytesFromJitterRNG(byArray, 0, byArray.length);
        assert (l == (long)this.byteSize);
        return byArray;
    }

    @Override
    public int entropySize() {
        return this.byteSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getRandomBytesFromJitterRNG(byte[] byArray, int n, int n2) {
        Object object = jentLock;
        synchronized (object) {
            if (errorMessage != null) {
                throw new EntropyProviderOperationException(errorMessage);
            }
            long l = 0L;
            long l2 = 0L;
            do {
                l = JitterEntropySource.randomBytes(ref.getReference(), byArray, n, n2);
                l = JitterEntropySource.handleErrorCode(l, true);
                n2 = (int)((long)n2 - l);
                n = (int)((long)n + l);
                l2 += l;
            } while (n2 > 0);
            return l2;
        }
    }

    long getRandomBytesFromJitterRNG(byte[] byArray) {
        return this.getRandomBytesFromJitterRNG(byArray, 0, byArray.length);
    }

    protected static void loadSettings() {
        memorySizeOrdinal = Properties.asInteger(MEMORY_ORDINAL_PROP_NAME, 0);
        overSampleRate = Properties.asInteger(OVERSAMPLE_PROP_NAME, -1);
        fipsMode = Properties.getPropertyValue(FIPS_MODE_OFF_PROP_NAME, "false").equals("false");
        restartLimit = Properties.asInteger(RESTART_LIMIT_PROP_NAME, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean rngAvailable() {
        Object object = jentLock;
        synchronized (object) {
            try {
                return JitterEntropySource.jitterRNGAvailable();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void errorCallback(int n) {
        Object object = jentLock;
        synchronized (object) {
            JitterEntropySource.handleErrorCode(n, false);
        }
    }

    protected static void restartJitter() {
        int n;
        if (BouncyCastleEntropyProvider.LOG.isLoggable(Level.FINE)) {
            BouncyCastleEntropyProvider.LOG.fine(String.format("restarting jitter rng, memory size ordinal: %d, over sample rate: %d, FIPS mode: %b", memorySizeOrdinal, overSampleRate, fipsMode));
        }
        if ((n = overSampleRate) < 0) {
            n = JitterEntropySource.minOverSample();
        }
        ref = new JentRef(JitterEntropySource.allocJitter(memorySizeOrdinal, n, fipsMode));
        errorMessage = null;
        if (errorStateConsumer != null) {
            errorStateConsumer.accept(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long handleErrorCode(long l, boolean bl) {
        Object object = jentLock;
        synchronized (object) {
            if (l >= 0L) {
                restartLimit = Properties.asInteger(RESTART_LIMIT_PROP_NAME, 8);
                return l;
            }
            String string = null;
            string = l == -1L ? "rng context not initialized" : (l == -2L ? "SP800-90B repetition count online health test failed" : (l == -3L ? "SP800-90B adaptive proportion online health test failed" : (l == -4L ? "internal timer generator cannot be initialized" : (l == -5L ? "LAG predictor health test failed" : (l == -99L ? "unknown health_failure code delivered to callback" : "unknown negative result: " + l)))));
            if (BouncyCastleEntropyProvider.LOG.isLoggable(Level.FINE)) {
                BouncyCastleEntropyProvider.LOG.fine(string);
            }
            if (restartLimit > 0) {
                --restartLimit;
                if (BouncyCastleEntropyProvider.LOG.isLoggable(Level.FINE)) {
                    BouncyCastleEntropyProvider.LOG.fine(String.format("restarting, %d restarts remaining", restartLimit));
                }
                JitterEntropySource.restartJitter();
                return 0L;
            }
            errorMessage = string;
            if (errorStateConsumer != null) {
                errorStateConsumer.accept(errorMessage);
            }
            if (bl) {
                throw new EntropyProviderOperationException(errorMessage);
            }
        }
        return l;
    }

    protected static native void initJitter();

    protected static native long allocJitter(int var0, int var1, boolean var2);

    protected static native long randomBytes(long var0, byte[] var2, int var3, int var4);

    protected static native boolean jitterRNGAvailable();

    protected static native void dispose(long var0);

    protected static native void testTriggerErrorCallback(int var0);

    protected static native void testSpikeRNG(long var0);

    protected static native int minOverSample();

    protected static native String buildTimeStamp();

    protected static native long jitterLibVersion();

    protected static native String nativeCompilerInfo();

    public String toString() {
        return "JitterEntropySource";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void testing_setErrorMessage(String string) {
        Object object = jentLock;
        synchronized (object) {
            errorMessage = string;
            if (errorStateConsumer != null) {
                errorStateConsumer.accept(errorMessage);
            }
        }
    }

    protected static void testing_makeFreshInstance() {
        JitterEntropySource.loadSettings();
        ref = new JentRef(JitterEntropySource.allocJitter(memorySizeOrdinal, JitterEntropySource.minOverSample(), fipsMode));
        startCalled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String testing_getErrorMessage() {
        Object object = jentLock;
        synchronized (object) {
            return errorMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void testing_setErrorStateConsumer(Consumer consumer) {
        Object object = jentLock;
        synchronized (object) {
            errorStateConsumer = consumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long testing_getRef() {
        Object object = jentLock;
        synchronized (object) {
            if (ref == null) {
                return -1L;
            }
            return ref.getReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int testing_getRestartLimit() {
        Object object = jentLock;
        synchronized (object) {
            return restartLimit;
        }
    }

    static {
        block3: {
            jentLock = new Object();
            startCalled = false;
            initCalled = false;
            errorMessage = null;
            try {
                if (Loader.isLibsInstalled()) {
                    JitterEntropySource.initJitter();
                }
                initCalled = true;
            }
            catch (IllegalStateException illegalStateException) {
                if (!BouncyCastleEntropyProvider.LOG.isLoggable(Level.FINE)) break block3;
                BouncyCastleEntropyProvider.LOG.fine("possible attempt to set jitter error callback more than once: " + illegalStateException.getMessage());
            }
        }
    }

    private static class JentRef
    extends NativeReference {
        public JentRef(long l) {
            super(l, "JitterRNG");
        }

        @Override
        protected Runnable createAction() {
            return new Runnable(){

                @Override
                public void run() {
                    JitterEntropySource.dispose(this.getReference());
                }
            };
        }
    }
}

