/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.entropy.provider;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.entropy.provider.DRBGUtils;
import org.bouncycastle.entropy.provider.Digest;
import org.bouncycastle.entropy.provider.EntropyProviderOperationException;
import org.bouncycastle.entropy.provider.EntropyProviderStatus;
import org.bouncycastle.entropy.provider.EntropySource;
import org.bouncycastle.entropy.provider.SHA512Digest;
import org.bouncycastle.entropy.provider.SP80090DRBG;
import org.bouncycastle.entropy.util.Arrays;
import org.bouncycastle.entropy.util.Hex;

class HashSP800DRBG
implements SP80090DRBG {
    private static final byte[] ZERO = new byte[]{0};
    private static final byte[] ONE = new byte[]{1};
    private static final long RESEED_MAX = 0x800000000000L;
    private static final int MAX_BITS_REQUEST = 262144;
    private static final Map<String, Integer> seedlens = new HashMap<String, Integer>();
    private static final Map<String, byte[][]> kats = new HashMap<String, byte[][]>();
    private static final Map<String, byte[]> reseedVs = new HashMap<String, byte[]>();
    private static final Map<String, byte[][]> reseedKats = new HashMap<String, byte[][]>();
    private Digest _digest;
    private WorkingBuffer workingBuf = new WorkingBuffer();
    private long _reseedCounter;
    private EntropySource _entropySource;
    private int _securityStrength;
    private int _seedLength;
    private byte[] _personalizationString;

    public HashSP800DRBG(SHA512Digest sHA512Digest, int n, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        this.init(sHA512Digest, n, entropySource, byArray, byArray2);
    }

    static void selfTest() {
        HashSP800DRBG hashSP800DRBG = new HashSP800DRBG(new SHA512Digest(), 256, new DRBGUtils.KATEntropyProvider().get(256), new byte[256], new byte[256]);
        hashSP800DRBG.doSelfTest();
        hashSP800DRBG.doReseedSelfTest();
    }

    private void init(Digest digest, int n, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        if (n > DRBGUtils.getMaxSecurityStrength(digest)) {
            throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
        }
        if (entropySource.entropySize() < n) {
            throw new IllegalArgumentException("Not enough entropy for security strength required");
        }
        this._digest = digest;
        this._entropySource = entropySource;
        this._securityStrength = n;
        this._personalizationString = Arrays.clone(byArray);
        this._seedLength = seedlens.get(digest.getAlgorithmName());
        byte[] byArray3 = this.getEntropy();
        byte[] byArray4 = Arrays.concatenate(byArray3, byArray2, byArray);
        Arrays.fill(byArray3, (byte)0);
        this.reseedFromSeedMaterial(byArray4);
    }

    @Override
    public int getBlockSize() {
        return this._digest.getDigestSize() * 8;
    }

    @Override
    public int getSecurityStrength() {
        return this._securityStrength;
    }

    @Override
    public byte[] getPersonalizationString() {
        return Arrays.clone(this._personalizationString);
    }

    @Override
    public int generate(byte[] byArray, byte[] byArray2, boolean bl) {
        byte[] byArray3;
        byte[] byArray4;
        int n = byArray.length * 8;
        if (n > 262144) {
            throw new IllegalArgumentException("Number of bits per request limited to 262144");
        }
        if (bl) {
            this.reseed(byArray2);
            byArray2 = null;
        }
        if (this._reseedCounter > 0x800000000000L) {
            return -1;
        }
        if (byArray2 != null) {
            byArray4 = new byte[1 + this.workingBuf._V.length + byArray2.length];
            byArray4[0] = 2;
            System.arraycopy(this.workingBuf._V, 0, byArray4, 1, this.workingBuf._V.length);
            System.arraycopy(byArray2, 0, byArray4, 1 + this.workingBuf._V.length, byArray2.length);
            byArray3 = this.hash(byArray4);
            this.addTo(this.workingBuf._V, byArray3);
        }
        byArray4 = this.hashgen(this.workingBuf._V, n);
        byArray3 = new byte[this.workingBuf._V.length + 1];
        System.arraycopy(this.workingBuf._V, 0, byArray3, 1, this.workingBuf._V.length);
        byArray3[0] = 3;
        byte[] byArray5 = this.hash(byArray3);
        this.addTo(this.workingBuf._V, byArray5);
        this.addTo(this.workingBuf._V, this.workingBuf._C);
        byte[] byArray6 = new byte[]{(byte)(this._reseedCounter >> 24), (byte)(this._reseedCounter >> 16), (byte)(this._reseedCounter >> 8), (byte)this._reseedCounter};
        this.addTo(this.workingBuf._V, byArray6);
        ++this._reseedCounter;
        System.arraycopy(byArray4, 0, byArray, 0, byArray.length);
        return n;
    }

    private void addTo(byte[] byArray, byte[] byArray2) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 1; n2 <= byArray2.length; ++n2) {
            n = (byArray[byArray.length - n2] & 0xFF) + (byArray2[byArray2.length - n2] & 0xFF) + n3;
            n3 = n > 255 ? 1 : 0;
            byArray[byArray.length - n2] = (byte)n;
        }
        for (n2 = byArray2.length + 1; n2 <= byArray.length; ++n2) {
            n = (byArray[byArray.length - n2] & 0xFF) + n3;
            n3 = n > 255 ? 1 : 0;
            byArray[byArray.length - n2] = (byte)n;
        }
    }

    @Override
    public void reseed(byte[] byArray) {
        byte[] byArray2 = this.getEntropy();
        byte[] byArray3 = Arrays.concatenate(ONE, this.workingBuf._V, byArray2, byArray);
        Arrays.fill(byArray2, (byte)0);
        this.reseedFromSeedMaterial(byArray3);
    }

    private void reseedFromSeedMaterial(byte[] byArray) {
        WorkingBuffer.access$102(this.workingBuf, this.hashSeedMaterial(byArray));
        WorkingBuffer.access$202(this.workingBuf, this.hashSeedMaterial(Arrays.concatenate(ZERO, this.workingBuf._V)));
        this._reseedCounter = 1L;
    }

    private byte[] hashSeedMaterial(byte[] byArray) {
        try {
            byte[] byArray2 = DRBGUtils.hash_df(this._digest, byArray, this._seedLength);
            return byArray2;
        }
        finally {
            Arrays.fill(byArray, (byte)0);
        }
    }

    private byte[] getEntropy() {
        byte[] byArray = this._entropySource.getEntropy();
        if (byArray == null || byArray.length < (this._securityStrength + 7) / 8) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSelfTest() throws EntropyProviderOperationException {
        byte[] byArray = this.workingBuf._V;
        byte[] byArray2 = this.workingBuf._C;
        byte[] byArray3 = this._personalizationString;
        long l = this._reseedCounter;
        EntropySource entropySource = this._entropySource;
        int n = this._seedLength;
        int n2 = this._securityStrength;
        try {
            int n3;
            byte[] byArray4;
            byte[] byArray5;
            block16: {
                block15: {
                    block14: {
                        byArray5 = Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F70717273747576");
                        byArray4 = Hex.decode("2021222324");
                        n3 = DRBGUtils.getMaxSecurityStrength(this._digest);
                        byte[][] byArray6 = kats.get(this._digest.getAlgorithmName());
                        this.init(this._digest, this._securityStrength, new DRBGUtils.KATEntropyProvider().get(n3), byArray5, byArray4);
                        byte[] byArray7 = new byte[byArray6[0].length];
                        this.generate(byArray7, null, true);
                        if (!Arrays.areEqual(byArray6[0], byArray7)) {
                            EntropyProviderStatus.fail("DRBG Block 1 KAT failure");
                        }
                        byArray7 = new byte[byArray6[1].length];
                        this.generate(byArray7, null, true);
                        if (!Arrays.areEqual(byArray6[1], byArray7)) {
                            EntropyProviderStatus.fail("DRBG Block 2 KAT failure");
                        }
                        try {
                            this.init(this._digest, this._securityStrength, new DRBGUtils.LyingEntropySource(n3), byArray5, byArray4);
                            EntropyProviderStatus.fail("DRBG LyingEntropySource not detected in init");
                        }
                        catch (IllegalStateException illegalStateException) {
                            if (illegalStateException.getMessage().equals("Insufficient entropy provided by entropy source")) break block14;
                            EntropyProviderStatus.fail("DRBG self test failed init entropy check");
                        }
                    }
                    try {
                        this.init(this._digest, this._securityStrength, new DRBGUtils.LyingEntropySource(20), byArray5, byArray4);
                        EntropyProviderStatus.fail("DRBG insufficient EntropySource not detected");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (illegalArgumentException.getMessage().equals("Not enough entropy for security strength required")) break block15;
                        EntropyProviderStatus.fail("DRBG self test failed init entropy check");
                    }
                }
                try {
                    this._entropySource = new DRBGUtils.LyingEntropySource(n3);
                    this.reseed(null);
                    EntropyProviderStatus.fail("DRBG LyingEntropySource not detected in reseed");
                }
                catch (IllegalStateException illegalStateException) {
                    if (illegalStateException.getMessage().equals("Insufficient entropy provided by entropy source")) break block16;
                    EntropyProviderStatus.fail("DRBG self test failed reseed entropy check");
                }
            }
            try {
                this.init(this._digest, n3 + 1, new DRBGUtils.KATEntropyProvider().get(n3), byArray5, byArray4);
                EntropyProviderStatus.fail("DRBG successful initialise with too high security strength");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!illegalArgumentException.getMessage().equals("Requested security strength is not supported by the derivation function")) {
                    EntropyProviderStatus.fail("DRBG self test failed init security strength check");
                }
            }
        }
        finally {
            WorkingBuffer.access$102(this.workingBuf, byArray);
            WorkingBuffer.access$202(this.workingBuf, byArray2);
            this._personalizationString = byArray3;
            this._reseedCounter = l;
            this._entropySource = entropySource;
            this._seedLength = n;
            this._securityStrength = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doReseedSelfTest() throws EntropyProviderOperationException {
        byte[] byArray = this.workingBuf._V;
        byte[] byArray2 = this.workingBuf._C;
        byte[] byArray3 = this._personalizationString;
        long l = this._reseedCounter;
        EntropySource entropySource = this._entropySource;
        int n = this._seedLength;
        int n2 = this._securityStrength;
        try {
            byte[] byArray4 = Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F70717273747576");
            int n3 = DRBGUtils.getMaxSecurityStrength(this._digest);
            byte[][] byArray5 = reseedKats.get(this._digest.getAlgorithmName());
            WorkingBuffer.access$102(this.workingBuf, Arrays.clone(reseedVs.get(this._digest.getAlgorithmName())));
            this._entropySource = new DRBGUtils.KATEntropyProvider().get(n3);
            this.reseed(byArray4);
            if (this._reseedCounter != 1L) {
                EntropyProviderStatus.fail("DRBG reseedCounter failed to reset");
            }
            byte[] byArray6 = new byte[byArray5[0].length];
            this.generate(byArray6, null, false);
            if (!Arrays.areEqual(byArray5[0], byArray6)) {
                EntropyProviderStatus.fail("DRBG Block 1 reseed KAT failure");
            }
            byArray6 = new byte[byArray5[1].length];
            this.generate(byArray6, null, false);
            if (!Arrays.areEqual(byArray5[1], byArray6)) {
                EntropyProviderStatus.fail("DRBG Block 2 reseed KAT failure");
            }
            try {
                this._entropySource = new DRBGUtils.LyingEntropySource(n3);
                this.reseed(null);
                EntropyProviderStatus.fail("DRBG LyingEntropySource not detected on reseed");
            }
            catch (IllegalStateException illegalStateException) {
                if (!illegalStateException.getMessage().equals("Insufficient entropy provided by entropy source")) {
                    EntropyProviderStatus.fail("DRBG self test failed reseed entropy check");
                }
            }
        }
        finally {
            WorkingBuffer.access$102(this.workingBuf, byArray);
            WorkingBuffer.access$202(this.workingBuf, byArray2);
            this._personalizationString = byArray3;
            this._reseedCounter = l;
            this._entropySource = entropySource;
            this._seedLength = n;
            this._securityStrength = n2;
        }
    }

    private byte[] hash(byte[] byArray) {
        byte[] byArray2 = new byte[this._digest.getDigestSize()];
        this.doHash(byArray, byArray2);
        return byArray2;
    }

    private void doHash(byte[] byArray, byte[] byArray2) {
        this._digest.update(byArray, 0, byArray.length);
        this._digest.doFinal(byArray2, 0);
    }

    private byte[] hashgen(byte[] byArray, int n) {
        int n2 = this._digest.getDigestSize();
        int n3 = n / 8 / n2;
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byte[] byArray3 = new byte[n / 8];
        byte[] byArray4 = new byte[this._digest.getDigestSize()];
        for (int i = 0; i <= n3; ++i) {
            this.doHash(byArray2, byArray4);
            int n4 = byArray3.length - i * byArray4.length > byArray4.length ? byArray4.length : byArray3.length - i * byArray4.length;
            System.arraycopy(byArray4, 0, byArray3, i * byArray4.length, n4);
            this.addTo(byArray2, ONE);
        }
        return byArray3;
    }

    static {
        seedlens.put("SHA-512", 888);
        kats.put("SHA-512", new byte[][]{Hex.decode("ca8387ba70bc7f8cb71e5d25703972ed58c7b5c81649050cdc17a9f646f7bd57857ca715e411d2ca"), Hex.decode("ce2fe5ba54cde888bee0f4863ca70b258ab6e2be31523542a4da66033433fb8e7e394b28198daa1e")});
        reseedVs.put("SHA-512", Hex.decode("397118fdac8d83ad98813c50759c85b8c47565d8268bf10da483153b747a74743a58a90e85aa9f705ce6984ffc128db567489817e4092d050d8a1cc596ddc119"));
        reseedKats.put("SHA-512", new byte[][]{Hex.decode("147abe77d9b19bf6331691eeb3571e55afb406d1ddcd7aa5f1b3de71f0d3eb6949ea580764588000"), Hex.decode("59c18dd408b82f930411bfdeea503d0154a77263c934d7888677ce34018307d4dd035effed210979")});
    }

    private static class WorkingBuffer {
        private byte[] _V;
        private byte[] _C;

        private WorkingBuffer() {
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Arrays.fill(this._V, (byte)0);
            Arrays.fill(this._C, (byte)0);
        }

        static /* synthetic */ byte[] access$102(WorkingBuffer workingBuffer, byte[] byArray) {
            workingBuffer._V = byArray;
            return byArray;
        }

        static /* synthetic */ byte[] access$202(WorkingBuffer workingBuffer, byte[] byArray) {
            workingBuffer._C = byArray;
            return byArray;
        }
    }
}

