/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.entropy.provider;

import java.util.Hashtable;
import org.bouncycastle.entropy.provider.Digest;
import org.bouncycastle.entropy.provider.EntropyProviderOperationException;
import org.bouncycastle.entropy.provider.KeyParameter;
import org.bouncycastle.entropy.provider.SHA512Digest;
import org.bouncycastle.entropy.util.Arrays;
import org.bouncycastle.entropy.util.Hex;
import org.bouncycastle.entropy.util.Strings;

class HMac {
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private Digest digest;
    private int digestSize;
    private int blockLength;
    private byte[] inputPad;
    private byte[] outputBuf;
    private static Hashtable blockLengths = new Hashtable();

    private static int getByteLength(Digest digest) {
        if (digest instanceof Digest) {
            return digest.getByteLength();
        }
        Integer n = (Integer)blockLengths.get(digest.getAlgorithmName());
        if (n == null) {
            throw new IllegalArgumentException("unknown digest passed: " + digest.getAlgorithmName());
        }
        return n;
    }

    public HMac(Digest digest) {
        this(digest, HMac.getByteLength(digest));
    }

    private HMac(Digest digest, int n) {
        this.digest = digest;
        this.digestSize = digest.getDigestSize();
        this.blockLength = n;
        this.inputPad = new byte[this.blockLength];
        this.outputBuf = new byte[this.blockLength + this.digestSize];
    }

    public String getAlgorithmName() {
        return this.digest.getAlgorithmName() + "/HMAC";
    }

    public Digest getUnderlyingDigest() {
        return this.digest;
    }

    public void init(KeyParameter keyParameter) {
        this.digest.reset();
        byte[] byArray = keyParameter.getKey();
        int n = byArray.length;
        if (n > this.blockLength) {
            this.digest.update(byArray, 0, n);
            this.digest.doFinal(this.inputPad, 0);
            n = this.digestSize;
        } else {
            System.arraycopy(byArray, 0, this.inputPad, 0, n);
        }
        for (int i = n; i < this.inputPad.length; ++i) {
            this.inputPad[i] = 0;
        }
        System.arraycopy(this.inputPad, 0, this.outputBuf, 0, this.blockLength);
        HMac.xorPad(this.inputPad, this.blockLength, (byte)54);
        HMac.xorPad(this.outputBuf, this.blockLength, (byte)92);
        this.digest.update(this.inputPad, 0, this.inputPad.length);
    }

    public int getMacSize() {
        return this.digestSize;
    }

    public void update(byte by) {
        this.digest.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    public int doFinal(byte[] byArray, int n) {
        this.digest.doFinal(this.outputBuf, this.blockLength);
        this.digest.update(this.outputBuf, 0, this.outputBuf.length);
        int n2 = this.digest.doFinal(byArray, n);
        for (int i = this.blockLength; i < this.outputBuf.length; ++i) {
            this.outputBuf[i] = 0;
        }
        this.digest.update(this.inputPad, 0, this.inputPad.length);
        return n2;
    }

    public void reset() {
        this.digest.reset();
        this.digest.update(this.inputPad, 0, this.inputPad.length);
    }

    private static void xorPad(byte[] byArray, int n, byte by) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            byArray[n3] = (byte)(byArray[n3] ^ by);
        }
    }

    static void selfTest() throws EntropyProviderOperationException {
        HMac.startUpTest();
    }

    private static void startUpTest() throws EntropyProviderOperationException {
        byte[] byArray = Strings.toByteArray("what do ya want for nothing?");
        HMac hMac = new HMac(new SHA512Digest());
        hMac.init(new KeyParameter(Hex.decode("4a656665")));
        hMac.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[hMac.getMacSize()];
        hMac.doFinal(byArray2, 0);
        hMac.reset();
        if (!Arrays.areEqual(byArray2, Hex.decode("164b7a7bfcf819e2e395fbe73b56e0a387bd64222e831fd610270cd7ea2505549758bf75c05a994a6d034f65f8f0e6fdcaeab1a34d4a6b4b636e070a38bce737"))) {
            throw new EntropyProviderOperationException("HMAC_SHA512 KAT Test failed");
        }
    }

    static {
        blockLengths.put("SHA-512", 128);
    }
}

