/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.entropy.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.bouncycastle.entropy.provider.BouncyCastleEntropyProvider;
import org.bouncycastle.entropy.provider.EntropyProviderOperationException;
import org.bouncycastle.entropy.provider.FipsOperationError;
import org.bouncycastle.entropy.provider.HMac;
import org.bouncycastle.entropy.provider.HashSP800DRBG;
import org.bouncycastle.entropy.provider.KeyParameter;
import org.bouncycastle.entropy.provider.Loader;
import org.bouncycastle.entropy.provider.SHA512Digest;
import org.bouncycastle.entropy.util.Arrays;
import org.bouncycastle.entropy.util.Hex;
import org.bouncycastle.entropy.util.Pack;
import org.bouncycastle.entropy.util.Strings;

public class EntropyProviderStatus {
    public static final String MODULE_HMAC_KEY = "Legion of the Bouncy Castle Inc.";
    private static Throwable statusException;
    private static final AtomicBoolean readyStatus;
    private static final Object statusLock;
    private static final String READY = "READY";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReady() {
        Object object = statusLock;
        synchronized (object) {
            try {
                SHA512Digest.selfTest();
                HMac.selfTest();
            }
            catch (Exception exception) {
                statusException = exception;
                return false;
            }
            EntropyProviderStatus.checksumValidate();
            try {
                HashSP800DRBG.selfTest();
            }
            catch (Exception exception) {
                statusException = exception;
                return false;
            }
            Loader.loadNativeLib();
            readyStatus.set(true);
            return readyStatus.get();
        }
    }

    public static Throwable getErrorThrowable() {
        return statusException;
    }

    public static void fail(String string) {
        Object object = statusLock;
        synchronized (object) {
            statusException = new EntropyProviderOperationException(string);
            throw (RuntimeException)statusException;
        }
    }

    public static boolean isErrorStatus() {
        return statusException != null;
    }

    public static String getStatusMessage() {
        try {
            EntropyProviderStatus.isReady();
        }
        catch (EntropyProviderOperationException entropyProviderOperationException) {
            // empty catch block
        }
        if (statusException != null) {
            return statusException.getMessage();
        }
        return READY;
    }

    private static void checksumValidate() {
        final String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return EntropyProviderStatus.getResourceName();
            }
        });
        if (string == null) {
            EntropyProviderStatus.moveToErrorStatus(new EntropyProviderOperationException("Module checksum failed: unable to find"));
        }
        if (string.startsWith("jrt:/")) {
            EntropyProviderStatus.moveToErrorStatus(new EntropyProviderOperationException("Module checksum failed: unable to calculate"));
        } else if (EntropyProviderStatus.checkValidJarUrl(string)) {
            try {
                JarInputStream jarInputStream = new JarInputStream(new URL(string).openStream());
                byte[][] byArray = EntropyProviderStatus.calculateModuleHMAC(jarInputStream);
                if (!Arrays.constantTimeAreEqual(byArray[0], byArray[1])) {
                    EntropyProviderStatus.moveToErrorStatus(new EntropyProviderOperationException("Module checksum failed: expected [" + Hex.toHexString(byArray[1]) + "] got [" + Hex.toHexString(byArray[0]) + "]"));
                }
            }
            catch (Exception exception) {
                statusException = exception;
                EntropyProviderStatus.moveToErrorStatus(new EntropyProviderOperationException("Module checksum failed: " + exception.getMessage(), exception));
            }
        } else {
            JarFile jarFile = AccessController.doPrivileged(new PrivilegedAction<JarFile>(){

                @Override
                public JarFile run() {
                    try {
                        return new JarFile(string);
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
            });
            if (jarFile != null) {
                try {
                    int n;
                    byte[] byArray = EntropyProviderStatus.calculateModuleHMAC(jarFile);
                    InputStream inputStream = jarFile.getInputStream(jarFile.getEntry("META-INF/HMAC.SHA512"));
                    StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
                    while ((n = inputStream.read()) >= 0 && n != 13 && n != 10) {
                        stringBuilder.append((char)n);
                    }
                    byte[] byArray2 = Hex.decode(stringBuilder.toString().trim());
                    if (!Arrays.constantTimeAreEqual(byArray, byArray2)) {
                        EntropyProviderStatus.moveToErrorStatus((Object)((Object)new FipsOperationError("Module checksum failed: expected [" + stringBuilder.toString().trim() + "] got [" + Strings.fromByteArray(Hex.encode(byArray)))) + "]");
                    }
                }
                catch (Exception exception) {
                    statusException = exception;
                    EntropyProviderStatus.moveToErrorStatus(new EntropyProviderOperationException("Module checksum failed: " + exception.getMessage(), exception));
                }
            }
        }
    }

    private static byte[] calculateModuleHMAC(JarFile jarFile) {
        try {
            Object object2;
            HMac hMac = new HMac(new SHA512Digest());
            hMac.init(new KeyParameter(Strings.toByteArray(MODULE_HMAC_KEY)));
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            Object object3 = jarFile.entries();
            while (object3.hasMoreElements()) {
                Object object4;
                object2 = object3.nextElement();
                if (EntropyProviderStatus.skipEntry((JarEntry)object2) || (object4 = treeMap.put(((ZipEntry)object2).getName(), object2)) == null) continue;
                IllegalStateException illegalStateException = new IllegalStateException("Unable to initialize module: duplicate entry found in jar file");
                statusException = illegalStateException;
                throw illegalStateException;
            }
            object3 = new byte[8192];
            for (Map.Entry entry : treeMap.entrySet()) {
                int n;
                JarEntry jarEntry = (JarEntry)entry.getValue();
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                byte[] byArray = Strings.toUTF8ByteArray(jarEntry.getName());
                hMac.update((byte)91);
                hMac.update(byArray, 0, byArray.length);
                hMac.update(Pack.longToBigEndian(jarEntry.getSize()), 0, 8);
                hMac.update((byte)93);
                while ((n = inputStream.read((byte[])object3, 0, ((Object)object3).length)) != -1) {
                    hMac.update((byte[])object3, 0, n);
                }
                inputStream.close();
            }
            hMac.update((byte)91);
            object2 = Strings.toUTF8ByteArray("END");
            hMac.update((byte[])object2, 0, ((Object)object2).length);
            hMac.update((byte)93);
            byte[] byArray = new byte[hMac.getMacSize()];
            hMac.doFinal(byArray, 0);
            return byArray;
        }
        catch (Exception exception) {
            return new byte[32];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[][] calculateModuleHMAC(JarInputStream jarInputStream) throws Exception {
        try {
            Object object;
            Object object3;
            JarEntry jarEntry;
            HMac hMac = new HMac(new SHA512Digest());
            hMac.init(new KeyParameter(Strings.toByteArray(MODULE_HMAC_KEY)));
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            byte[] byArray = null;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                if (jarEntry.getName().equals("META-INF/HMAC.SHA512")) {
                    byArray = Hex.decode(Strings.fromByteArray(EntropyProviderStatus.readAll(jarInputStream)).trim());
                    continue;
                }
                if (EntropyProviderStatus.skipEntry(jarEntry)) continue;
                object3 = Strings.toUTF8ByteArray(jarEntry.getName());
                ByteArrayOutputStream object22 = new ByteArrayOutputStream();
                object22.write(91);
                object22.write((byte[])object3, 0, ((Object)object3).length);
                object = EntropyProviderStatus.readAll(jarInputStream);
                object22.write(Pack.longToBigEndian(((byte[])object).length), 0, 8);
                object22.write(93);
                object22.write((byte[])object, 0, ((byte[])object).length);
                byte[] byArray2 = treeMap.put(jarEntry.getName(), object22.toByteArray());
                if (byArray2 == null) continue;
                IllegalStateException illegalStateException = new IllegalStateException("Unable to initialize module: duplicate entry found in jar file");
                statusException = illegalStateException;
                throw illegalStateException;
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                object = (byte[])entry.getValue();
                hMac.update((byte[])object, 0, ((byte[])object).length);
            }
            hMac.update((byte)91);
            object3 = Strings.toUTF8ByteArray("END");
            hMac.update((byte[])object3, 0, ((Object)object3).length);
            hMac.update((byte)93);
            byte[] byArray3 = new byte[hMac.getMacSize()];
            hMac.doFinal(byArray3, 0);
            object = new byte[][]{byArray3, byArray};
            return object;
        }
        finally {
            jarInputStream.close();
        }
    }

    private static boolean skipEntry(JarEntry jarEntry) {
        if (jarEntry.isDirectory() || jarEntry.getName().indexOf("module-info.class") > 0) {
            return true;
        }
        if (jarEntry.getName().startsWith("META-INF/")) {
            if (jarEntry.getName().contains("OSGI-INF/")) {
                return true;
            }
            if (jarEntry.getName().indexOf("versions/") < 0) {
                return true;
            }
        }
        return false;
    }

    private static String getResourceName() {
        String string = null;
        String string2 = BouncyCastleEntropyProvider.class.getCanonicalName().replace(".", "/").replace("BouncyCastleEntropyProvider", "MARKER");
        String string3 = EntropyProviderStatus.getMarker(BouncyCastleEntropyProvider.class, string2);
        if (string3 != null) {
            if (string3.startsWith("jar:") && string3.contains("!/")) {
                if (string3.startsWith("jar:bundle")) {
                    return string3.substring(0, string3.indexOf(33));
                }
                try {
                    String string4;
                    int n = string3.indexOf(58, 4);
                    if (n == -1) {
                        return null;
                    }
                    string = string4 = URLDecoder.decode(string3.substring(n + 1, string3.lastIndexOf("!/")), "UTF-8");
                }
                catch (IOException iOException) {
                    string = null;
                }
            } else if (string3.startsWith("file:") && string3.endsWith(".jar")) {
                try {
                    String string5;
                    string = string5 = URLDecoder.decode(string3.substring("file:".length()), "UTF-8");
                }
                catch (IOException iOException) {
                    string = null;
                }
            } else {
                if (string3.startsWith("vfs:")) {
                    return string3;
                }
                if (string3.startsWith("jrt:")) {
                    return string3;
                }
                if (string3.startsWith("file:")) {
                    return string3;
                }
                if (EntropyProviderStatus.checkValidJarUrl(string3)) {
                    return string3;
                }
            }
        }
        return string;
    }

    static String getMarker(final Class clazz, final String string) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            Object t = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
                        return codeSource.getLocation();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            if (t != null) {
                return t.toString();
            }
            return classLoader.getResource(string).toString();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return ClassLoader.getSystemResource(string).toString();
            }
        });
    }

    private static boolean checkValidJarUrl(String string) {
        return (string.startsWith("http://") || string.startsWith("https://")) && string.endsWith(".jar");
    }

    static void moveToErrorStatus(String string) {
        EntropyProviderStatus.moveToErrorStatus(new EntropyProviderOperationException(string));
    }

    static void moveToErrorStatus(EntropyProviderOperationException entropyProviderOperationException) {
        statusException = entropyProviderOperationException;
        throw (EntropyProviderOperationException)statusException;
    }

    public static byte[] getModuleHMAC() {
        try {
            String string = EntropyProviderStatus.getResourceName();
            return EntropyProviderStatus.calculateModuleHMAC(new JarFile(string));
        }
        catch (Exception exception) {
            return new byte[64];
        }
    }

    private static byte[] readAll(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EntropyProviderStatus.pipeAll(inputStream, byteArrayOutputStream, 4096);
        return byteArrayOutputStream.toByteArray();
    }

    private static void pipeAll(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        while ((n2 = inputStream.read(byArray, 0, byArray.length)) >= 0) {
            outputStream.write(byArray, 0, n2);
        }
    }

    static {
        readyStatus = new AtomicBoolean(false);
        statusLock = new Object();
    }
}

