/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.entropy.provider;

import org.bouncycastle.entropy.provider.JitterEntropySource;
import org.bouncycastle.entropy.provider.Loader;

public class EntropyProviderInfo {
    public static boolean hasJitterRNG() {
        try {
            return JitterEntropySource.rngAvailable();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    public static String loaderStatus() {
        return Loader.getStatusMessage();
    }

    public static String loadedVariant() {
        return Loader.getLoadedVariant();
    }

    public static String loadedCompilerMajorVersion() {
        return Loader.getLoadedCompilerMajorVersion();
    }

    public static String nativeCompilerInfo() {
        try {
            return JitterEntropySource.nativeCompilerInfo();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return "Not Loaded";
        }
    }

    public static String nativeBuildTimeStamp() {
        try {
            return JitterEntropySource.buildTimeStamp();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return "Not Loaded";
        }
    }

    public static String jitterLibVersion() {
        try {
            long l = JitterEntropySource.jitterLibVersion();
            long l2 = l / 1000000L;
            long l3 = (l -= l2 * 1000000L) / 10000L;
            long l4 = (l -= l3 * 10000L) / 100L;
            return String.format("%d.%d.%d", l2, l3, l4);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return "Not Loaded";
        }
    }
}

