/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.entropy.provider;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.entropy.provider.Disposable;
import org.bouncycastle.entropy.provider.Properties;

class DisposalDaemon
implements Runnable {
    private static final Logger LOG = Logger.getLogger(DisposalDaemon.class.getName());
    private static final ReferenceQueue<Disposable> referenceQueue = new ReferenceQueue();
    private static final Set<ReferenceWrapperWithDisposerRunnable> refs = ConcurrentHashMap.newKeySet();
    private static final ScheduledExecutorService cleanupExecutor;
    private static final DisposalDaemon disposalDaemon;
    private static final Thread disposalThread;
    private static final long cleanupDelay;
    private static final String CLEANUP_DELAY_PROP = "org.bouncycastle.jent.native.cleanup_delay";

    DisposalDaemon() {
    }

    private static void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Shutdown hook started");
                }
                ReferenceWrapperWithDisposerRunnable referenceWrapperWithDisposerRunnable = (ReferenceWrapperWithDisposerRunnable)referenceQueue.poll();
                while (referenceWrapperWithDisposerRunnable != null) {
                    refs.remove(referenceWrapperWithDisposerRunnable);
                    referenceWrapperWithDisposerRunnable.dispose();
                    referenceWrapperWithDisposerRunnable = (ReferenceWrapperWithDisposerRunnable)referenceQueue.poll();
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("Shutdown hook disposed: " + referenceWrapperWithDisposerRunnable);
                }
            }
        });
    }

    public static void addDisposable(Disposable disposable) {
        ReferenceWrapperWithDisposerRunnable referenceWrapperWithDisposerRunnable = new ReferenceWrapperWithDisposerRunnable(disposable, referenceQueue);
        refs.add(referenceWrapperWithDisposerRunnable);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Registered: " + disposable.toString());
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    final ReferenceWrapperWithDisposerRunnable referenceWrapperWithDisposerRunnable = (ReferenceWrapperWithDisposerRunnable)referenceQueue.remove();
                    refs.remove(referenceWrapperWithDisposerRunnable);
                    cleanupExecutor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Disposed: " + referenceWrapperWithDisposerRunnable);
                            }
                            referenceWrapperWithDisposerRunnable.dispose();
                        }
                    }, cleanupDelay, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (Throwable throwable) {
                LOG.warning("exception in disposal thread: " + throwable.getMessage());
                continue;
            }
            break;
        }
    }

    static {
        disposalDaemon = new DisposalDaemon();
        cleanupDelay = Properties.asInteger(CLEANUP_DELAY_PROP, 5);
        cleanupExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "JENT Cleanup Executor");
                thread.setDaemon(true);
                return thread;
            }
        });
        disposalThread = new Thread((Runnable)disposalDaemon, "JENT Disposal Daemon");
        disposalThread.setDaemon(true);
        disposalThread.start();
        DisposalDaemon.addShutdownHook();
    }

    private static class ReferenceWrapperWithDisposerRunnable
    extends PhantomReference<Disposable> {
        private final Runnable disposer;
        private final String label;

        public ReferenceWrapperWithDisposerRunnable(Disposable disposable, ReferenceQueue<? super Disposable> referenceQueue) {
            super(disposable, referenceQueue);
            this.label = disposable.toString();
            this.disposer = disposable.getDisposeAction();
        }

        public void dispose() {
            this.disposer.run();
        }

        public String toString() {
            return this.label;
        }
    }
}

