/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.entropy.provider;

import java.security.SecureRandomSpi;
import org.bouncycastle.entropy.provider.ContinuousTestingPseudoRNG;
import org.bouncycastle.entropy.provider.HashSP800DRBG;
import org.bouncycastle.entropy.provider.JitterEntropySource;
import org.bouncycastle.entropy.provider.SHA512Digest;
import org.bouncycastle.entropy.util.Strings;

class DRBGSecureRandomSpi
extends SecureRandomSpi {
    private final JitterEntropySource entropySource;
    private final ContinuousTestingPseudoRNG drbg;

    DRBGSecureRandomSpi(JitterEntropySource jitterEntropySource) {
        this.entropySource = jitterEntropySource;
        byte[] byArray = Strings.toByteArray(String.format("Bouncy Castle Entropy DRBG %d, %d", System.currentTimeMillis(), Thread.currentThread().getId()));
        byte[] byArray2 = new byte[jitterEntropySource.entropySize() >> 3];
        long l = jitterEntropySource.getRandomBytesFromJitterRNG(byArray2, 0, byArray2.length);
        if (l != (long)byArray2.length) {
            throw new IllegalStateException("not enough entropy to fill nonce");
        }
        this.drbg = new ContinuousTestingPseudoRNG(new HashSP800DRBG(new SHA512Digest(), this.entropySource.entropySize(), this.entropySource, byArray, byArray2), Strings.toByteArray("Bouncy Castle Entropy DRBG"));
    }

    @Override
    protected void engineSetSeed(byte[] byArray) {
    }

    @Override
    protected void engineNextBytes(byte[] byArray) {
        this.drbg.generate(byArray, null, true);
    }

    @Override
    protected byte[] engineGenerateSeed(int n) {
        byte[] byArray = new byte[n];
        long l = this.entropySource.getRandomBytesFromJitterRNG(byArray);
        assert (l == (long)byArray.length);
        return byArray;
    }

    @Override
    public String toString() {
        return "DRBGSecureRandomSpi[" + this.entropySource.toString() + "]";
    }
}

