/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.entropy.provider;

import java.io.ByteArrayOutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.bouncycastle.entropy.provider.ContinuousTestingPseudoRNG;
import org.bouncycastle.entropy.provider.DRBGSecureRandomSpi;
import org.bouncycastle.entropy.provider.EntropyProviderOperationException;
import org.bouncycastle.entropy.provider.EntropyProviderStatus;
import org.bouncycastle.entropy.provider.EntropySource;
import org.bouncycastle.entropy.provider.FailedRNG;
import org.bouncycastle.entropy.provider.HMac;
import org.bouncycastle.entropy.provider.HashSP800DRBG;
import org.bouncycastle.entropy.provider.JitterEntropySource;
import org.bouncycastle.entropy.provider.KeyParameter;
import org.bouncycastle.entropy.provider.Loader;
import org.bouncycastle.entropy.provider.Properties;
import org.bouncycastle.entropy.provider.SHA512Digest;
import org.bouncycastle.entropy.util.Arrays;

public class BouncyCastleEntropyProvider
extends Provider {
    static final Logger LOG = Logger.getLogger(BouncyCastleEntropyProvider.class.getName());
    public static final String VERSION = "1.3.6";
    public static final String INFO = "Bouncy Castle JENT Entropy Provider v1.3.6";
    public static final String NAME = "BCRNG";
    private static ByteArrayOutputStream timingDeltaBuf;

    public BouncyCastleEntropyProvider() {
        super(NAME, 1.36, INFO);
        EntropyProviderStatus.isReady();
        if (!Loader.isNativeJEntInstalled()) {
            LOG.fine("Loading JitterEntropy Failed: " + Loader.getStatusMessage());
            return;
        }
        if (!JitterEntropySource.rngAvailable()) {
            LOG.fine("jitter rng not enabled on this platform");
        }
    }

    public static String getInfoString() {
        return INFO;
    }

    @Override
    public String getInfo() {
        Loader.loadNativeLib();
        return super.getInfo() + " [" + Loader.getLoadedVariant() + " " + Loader.getLoadedCompilerMajorVersion() + " " + Loader.getStatusMessage() + "]";
    }

    @Override
    public final synchronized Provider.Service getService(String string, String string2) {
        String string3 = BouncyCastleEntropyProvider.toUpperCase(string2);
        if ("SecureRandom.ENTROPY".equals(string + "." + string3)) {
            return new RngService(this);
        }
        return null;
    }

    @Override
    public final synchronized Set<Provider.Service> getServices() {
        Set<Provider.Service> set = super.getServices();
        LinkedHashSet<Provider.Service> linkedHashSet = new LinkedHashSet<Provider.Service>();
        for (Provider.Service service : set) {
            linkedHashSet.add(this.getService(service.getType(), service.getAlgorithm()));
        }
        return linkedHashSet;
    }

    private static String toUpperCase(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i != cArray.length; ++i) {
            char c = cArray[i];
            if ('a' > c || 'z' < c) continue;
            bl = true;
            cArray[i] = (char)(c - 97 + 65);
        }
        if (bl) {
            return new String(cArray);
        }
        return string;
    }

    public static Object functionTest(String string, Object ... objectArray) throws Exception {
        if (string.equals("sha512")) {
            SHA512Digest sHA512Digest = new SHA512Digest();
            byte[] byArray = (byte[])objectArray[0];
            sHA512Digest.update(byArray, 0, byArray.length);
            byArray = new byte[sHA512Digest.getDigestSize()];
            sHA512Digest.doFinal(byArray, 0);
            return byArray;
        }
        if (string.equals("hmac512")) {
            byte[] byArray = (byte[])objectArray[0];
            byte[] byArray2 = (byte[])objectArray[1];
            HMac hMac = new HMac(new SHA512Digest());
            hMac.init(new KeyParameter(byArray));
            hMac.update(byArray2, 0, byArray2.length);
            byArray2 = new byte[hMac.getMacSize()];
            hMac.doFinal(byArray2, 0);
            return byArray2;
        }
        if (string.equals("jitter_sha3")) {
            byte[] byArray = objectArray[0] != null ? (byte[])objectArray[0] : null;
            byte[] byArray3 = objectArray[1] != null ? (byte[])objectArray[1] : null;
            long l = 0L;
            long l2 = 0L;
            if (objectArray.length > 2) {
                l = (Long)objectArray[2];
                l2 = (Long)objectArray[3];
            }
            BouncyCastleEntropyProvider.jitterSha3Acvp(byArray, byArray3, l, l2);
            return byArray3;
        }
        if (string.equals("hashdrbg")) {
            boolean bl = (Boolean)objectArray[0];
            List list = (List)objectArray[1];
            byte[] byArray = (byte[])objectArray[2];
            int n = (Integer)objectArray[3];
            byte[] byArray4 = (byte[])objectArray[4];
            int n2 = (Integer)objectArray[5];
            byte[] byArray5 = (byte[])objectArray[6];
            int n3 = (Integer)objectArray[7];
            boolean bl2 = (Boolean)objectArray[8];
            byte[] byArray6 = new byte[n3 / 8];
            if (list != null) {
                Object object2;
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
                for (Object object2 : list) {
                    if ("reSeed".equals(object2.get("intendedUse"))) {
                        arrayList.add((byte[])object2.get("additionalInput"));
                        continue;
                    }
                    arrayList2.add((byte[])object2.get("additionalInput"));
                }
                FuncTestingEntropySource funcTestingEntropySource = new FuncTestingEntropySource(byArray, list, n);
                object2 = new FuncTestContinuousTestingEntropySource(funcTestingEntropySource);
                HashSP800DRBG hashSP800DRBG = new HashSP800DRBG(new SHA512Digest(), n / 2, (EntropySource)object2, byArray4, byArray5);
                ContinuousTestingPseudoRNG continuousTestingPseudoRNG = n2 == 0 ? new ContinuousTestingPseudoRNG(hashSP800DRBG, null) : new ContinuousTestingPseudoRNG(hashSP800DRBG, (byte[])arrayList2.get(0));
                if (!arrayList.isEmpty()) {
                    if (n2 == 0) {
                        continuousTestingPseudoRNG.reseed(null);
                    } else {
                        continuousTestingPseudoRNG.reseed((byte[])arrayList.get(0));
                    }
                }
                if (n2 == 0) {
                    continuousTestingPseudoRNG.generate(byArray6, null, bl2);
                } else {
                    continuousTestingPseudoRNG.generate(byArray6, (byte[])arrayList2.get(1), bl2);
                }
                return byArray6;
            }
            FuncTestingEntropySource funcTestingEntropySource = new FuncTestingEntropySource(byArray, list, n);
            FuncTestContinuousTestingEntropySource funcTestContinuousTestingEntropySource = new FuncTestContinuousTestingEntropySource(funcTestingEntropySource);
            HashSP800DRBG hashSP800DRBG = new HashSP800DRBG(new SHA512Digest(), n / 2, funcTestContinuousTestingEntropySource, byArray4, byArray5);
            ContinuousTestingPseudoRNG continuousTestingPseudoRNG = new ContinuousTestingPseudoRNG(hashSP800DRBG, null);
            if (bl) {
                continuousTestingPseudoRNG.reseed(null);
            }
            continuousTestingPseudoRNG.generate(byArray6, null, bl2);
            return byArray6;
        }
        if (string.equals("raw_entropy")) {
            long l = (Long)objectArray[0];
            int n = (Integer)objectArray[1];
            JitterEntropySource jitterEntropySource = new JitterEntropySource(n * 8);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
            while ((long)byteArrayOutputStream.size() < l) {
                byteArrayOutputStream.write(jitterEntropySource.getEntropy());
            }
            jitterEntropySource = null;
            return byteArrayOutputStream.toByteArray();
        }
        if (string.equals("collect_time_deltas")) {
            timingDeltaBuf = new ByteArrayOutputStream();
            BouncyCastleEntropyProvider.enableTimingDeltaReception(true);
        } else if (string.equals("has_native_sha3_access")) {
            try {
                BouncyCastleEntropyProvider.jitterSha3Acvp(new byte[32], new byte[32], 0L, 0L);
                return true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown name: " + string);
    }

    private static void acceptTimingDelta(long l) {
        if (timingDeltaBuf == null) {
            // empty if block
        }
    }

    private static native void jitterSha3Acvp(byte[] var0, byte[] var1, long var2, long var4);

    private static native void enableTimingDeltaReception(boolean var0);

    private static class FuncTestContinuousTestingEntropySource
    implements EntropySource {
        private final EntropySource entropySource;
        private byte[] buf;
        private FuncTestEntropyUtil.WindowStats windStats;

        public FuncTestContinuousTestingEntropySource(EntropySource entropySource) {
            this.entropySource = entropySource;
        }

        @Override
        public boolean isPredictionResistant() {
            return this.entropySource.isPredictionResistant();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getEntropy() {
            FuncTestContinuousTestingEntropySource funcTestContinuousTestingEntropySource = this;
            synchronized (funcTestContinuousTestingEntropySource) {
                byte[] byArray;
                String string;
                if (this.buf == null) {
                    this.buf = this.entropySource.getEntropy();
                    this.windStats = FuncTestEntropyUtil.createStats();
                    String string2 = FuncTestEntropyUtil.isProportionate(this.windStats, this.buf);
                    if (string2 != null) {
                        throw new IllegalStateException(string2);
                    }
                }
                int n = 0;
                int n2 = FuncTestEntropyConfig.getMaxRetries();
                do {
                    if ((string = FuncTestEntropyUtil.isNotStuck(this.buf[this.buf.length - 1], byArray = this.entropySource.getEntropy())) != null && ++n == n2) {
                        throw new IllegalStateException(string);
                    }
                    string = FuncTestEntropyUtil.isProportionate(this.windStats, byArray);
                    if (string != null && n == n2) {
                        throw new IllegalStateException(string);
                    }
                    if (!Arrays.areEqual(byArray, this.buf)) continue;
                    string = "Duplicate block detected in EntropySource output";
                    if (n != n2) continue;
                    throw new IllegalStateException(string);
                } while (string != null && n <= n2);
                System.arraycopy(byArray, 0, this.buf, 0, this.buf.length);
                return byArray;
            }
        }

        @Override
        public int entropySize() {
            return this.entropySource.entropySize();
        }
    }

    private static class FuncTestEntropyConfig {
        private static final int W = 512;
        private static int C;
        private static int AdptC;
        private static float H;
        private static int retry;

        private FuncTestEntropyConfig() {
        }

        public static float getH() {
            return H;
        }

        public static int getStuckC() {
            return C;
        }

        public static int getAdaptiveProportionateC() {
            return AdptC;
        }

        public static int getAdaptiveProportionateW() {
            return 512;
        }

        public static int getMaxRetries() {
            return retry;
        }

        static {
            Object object;
            String string = Properties.getPropertyValue("org.bouncycastle.entropy.factors");
            if (string != null) {
                object = string.split(",");
                if (((String[])object).length != 3) {
                    EntropyProviderStatus.moveToErrorStatus(new EntropyProviderOperationException("entropy factors needs to be <int>,<int>,<float>"));
                }
                try {
                    C = Integer.parseInt(object[0].trim());
                    AdptC = Integer.parseInt(object[1].trim());
                    H = Float.parseFloat(object[2].trim());
                }
                catch (Exception exception) {
                    EntropyProviderStatus.moveToErrorStatus(new EntropyProviderOperationException("exception parsing entropy factors: " + exception.getMessage(), exception));
                }
            } else {
                C = 4;
                AdptC = 13;
                H = 8.0f;
            }
            if ((object = Properties.getPropertyValue("org.bouncycastle.entropy.retry")) != null) {
                try {
                    retry = Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    EntropyProviderStatus.moveToErrorStatus(new EntropyProviderOperationException("exception parsing entropy retry: " + exception.getMessage(), exception));
                }
            } else {
                retry = 5;
            }
        }
    }

    private static class FuncTestEntropyUtil {
        private FuncTestEntropyUtil() {
        }

        static byte[] generateSeed(EntropySource entropySource, int n) {
            byte[] byArray = new byte[n];
            if (n * 8 <= entropySource.entropySize()) {
                byte[] byArray2 = entropySource.getEntropy();
                System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
            } else {
                int n2 = entropySource.entropySize() / 8;
                for (int i = 0; i < byArray.length; i += n2) {
                    byte[] byArray3 = entropySource.getEntropy();
                    if (byArray3.length <= byArray.length - i) {
                        System.arraycopy(byArray3, 0, byArray, i, byArray3.length);
                        continue;
                    }
                    System.arraycopy(byArray3, 0, byArray, i, byArray.length - i);
                }
            }
            return byArray;
        }

        static String isNotStuck(byte by, byte[] byArray) {
            int n = FuncTestEntropyConfig.getStuckC();
            if (byArray.length < n) {
                throw new IllegalArgumentException("alpha value too large for entropy size");
            }
            int n2 = 1;
            byte by2 = by;
            for (int i = 0; i != byArray.length; ++i) {
                byte by3 = byArray[i];
                if (by3 == by2) {
                    if (++n2 < n) continue;
                    return "entropy source stuck";
                }
                by2 = by3;
                n2 = 1;
            }
            return null;
        }

        static String isProportionate(WindowStats windowStats, byte[] byArray) {
            try {
                for (int i = 0; i < byArray.length; ++i) {
                    windowStats.check(byArray[i]);
                }
                return null;
            }
            catch (IllegalStateException illegalStateException) {
                return illegalStateException.getMessage();
            }
        }

        static WindowStats createStats() {
            return new WindowStats(FuncTestEntropyConfig.getAdaptiveProportionateC(), FuncTestEntropyConfig.getAdaptiveProportionateW());
        }

        static class WindowStats {
            private final int W;
            private final int adptC;
            byte a;
            int i;
            int b;

            WindowStats(int n, int n2) {
                this.adptC = n;
                this.W = n2;
                this.i = n2;
            }

            void incB() {
                ++this.b;
                if (this.b >= this.adptC) {
                    throw new IllegalStateException("proportionate test failed");
                }
            }

            void check(byte by) {
                if (this.i > this.W - 1) {
                    this.reset(by);
                } else if (this.a == by) {
                    this.incB();
                }
                ++this.i;
            }

            void reset(byte by) {
                this.b = 1;
                this.i = 0;
                this.a = by;
            }
        }
    }

    private static class FuncTestingEntropySource
    implements EntropySource {
        private final int bitsRequired;
        private boolean first = true;
        private byte[] data;
        private int count = 0;
        private final byte[] rv;

        private FuncTestingEntropySource(byte[] byArray, List<Map<String, Object>> list, int n) throws Exception {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(byArray);
            if (list != null) {
                for (Map<String, Object> map : list) {
                    byteArrayOutputStream.write((byte[])map.get("entropyInput"));
                }
            }
            this.data = byteArrayOutputStream.toByteArray();
            this.bitsRequired = n;
            this.rv = new byte[n / 8];
        }

        @Override
        public boolean isPredictionResistant() {
            return false;
        }

        @Override
        public byte[] getEntropy() {
            byte[] byArray = new byte[this.bitsRequired / 8];
            System.arraycopy(this.data, this.count, byArray, 0, byArray.length);
            if (this.first) {
                int n = 0;
                while (n != byArray.length) {
                    int n2 = n++;
                    byArray[n2] = (byte)(byArray[n2] ^ 0xFF);
                }
                this.first = false;
            } else {
                this.count += byArray.length;
            }
            return byArray;
        }

        @Override
        public int entropySize() {
            return this.bitsRequired;
        }
    }

    private static class RngService
    extends Provider.Service {
        public RngService(Provider provider) {
            super(provider, "SecureRandom", "ENTROPY", BouncyCastleEntropyProvider.class.getName() + "$DevRng", Collections.emptyList(), Collections.emptyMap());
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            try {
                if (JitterEntropySource.rngAvailable()) {
                    LOG.fine("JENT available.");
                    JitterEntropySource jitterEntropySource = new JitterEntropySource(256);
                    return new DRBGSecureRandomSpi(jitterEntropySource);
                }
                LOG.warning("unable to invoke JENT RNG");
                return new FailedRNG();
            }
            catch (Exception exception) {
                String string = "Unable to invoke creator for " + this.getAlgorithm() + ": " + exception.getMessage();
                EntropyProviderStatus.moveToErrorStatus(string);
                throw new NoSuchAlgorithmException(string, exception);
            }
        }
    }
}

