/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.DrbgParameters;
import java.security.SecureRandom;
import java.security.SecureRandomParameters;
import java.security.SecureRandomSpi;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvRandom
extends AsymmetricAlgorithmProvider {
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.random.";

    ProvRandom() {
    }

    @Override
    public void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("SecureRandom.DEFAULT", "org.bouncycastle.jcajce.provider.random.DefSecureRandom", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                SecureRandom random;
                if (constructorParameter == null) {
                    random = provider.getDefaultSecureRandom();
                } else {
                    SecureRandom entropySource = provider.getDefaultEntropySource();
                    DrbgParameters.Instantiation params = (DrbgParameters.Instantiation)constructorParameter;
                    random = provider.getProviderDefaultRandomBuilder().fromEntropySource(entropySource, true).setSecurityStrength(params.getStrength()).setPersonalizationString(params.getPersonalizationString()).build(entropySource.generateSeed(params.getStrength() / 16 + 1), params.getCapability() == DrbgParameters.Capability.PR_AND_RESEED, Strings.toByteArray("Bouncy Castle FIPS Custom Default"));
                }
                if (random instanceof FipsSecureRandom) {
                    return new MySecureRandomSpi((FipsSecureRandom)random);
                }
                return new SecureRandomSpi(){

                    @Override
                    protected void engineSetSeed(byte[] bytes) {
                        random.setSeed(bytes);
                    }

                    @Override
                    protected void engineNextBytes(byte[] bytes) {
                        random.nextBytes(bytes);
                    }

                    @Override
                    protected byte[] engineGenerateSeed(int numBytes) {
                        return random.generateSeed(numBytes);
                    }
                };
            }
        });
        provider.addAlgorithmImplementation("SecureRandom.NONCEANDIV", "org.bouncycastle.jcajce.provider.random.NonceAndIVSecureRandom", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                FipsSecureRandom random;
                SecureRandom entropySource = provider.getDefaultEntropySource();
                if (constructorParameter == null) {
                    random = provider.getProviderDefaultRandomBuilder().fromEntropySource(entropySource, true).setPersonalizationString(ProvRandom.this.generatePersonalizationString()).build(entropySource.generateSeed(provider.getProviderDefaultSecurityStrength() / 16 + 1), false, Strings.toByteArray("Bouncy Castle FIPS Provider Nonce/IV"));
                } else {
                    DrbgParameters.Instantiation params = (DrbgParameters.Instantiation)constructorParameter;
                    random = provider.getProviderDefaultRandomBuilder().fromEntropySource(entropySource, true).setSecurityStrength(params.getStrength()).setPersonalizationString(params.getPersonalizationString()).build(entropySource.generateSeed(params.getStrength() / 16 + 1), params.getCapability() == DrbgParameters.Capability.PR_AND_RESEED, Strings.toByteArray("Bouncy Castle FIPS Provider Custom Nonce/IV"));
                }
                return new MySecureRandomSpi(random);
            }
        });
    }

    private byte[] generatePersonalizationString() {
        return Arrays.concatenate(Strings.toByteArray("NonceAndIV"), Pack.longToLittleEndian(Thread.currentThread().getId()), Pack.longToLittleEndian(System.currentTimeMillis()));
    }

    private class MySecureRandomSpi
    extends SecureRandomSpi {
        private final FipsSecureRandom baseRandom;
        private final SecureRandomParameters params;

        protected MySecureRandomSpi(FipsSecureRandom baseRandom) {
            this.baseRandom = baseRandom;
            this.params = DrbgParameters.instantiation(baseRandom.getSecurityStrength(), baseRandom.isPredictionResistant() ? DrbgParameters.Capability.PR_AND_RESEED : DrbgParameters.Capability.RESEED_ONLY, baseRandom.getPersonalizationString());
        }

        @Override
        protected void engineSetSeed(byte[] bytes) {
            this.baseRandom.setSeed(bytes);
        }

        @Override
        protected void engineNextBytes(byte[] bytes, SecureRandomParameters params) {
            DrbgParameters.NextBytes p;
            if (params instanceof DrbgParameters.NextBytes) {
                p = (DrbgParameters.NextBytes)params;
                if (p.getStrength() > this.baseRandom.getSecurityStrength()) {
                    throw new IllegalArgumentException("maximum strength of DRBG is " + this.baseRandom.getSecurityStrength() + " bits");
                }
                if (p.getPredictionResistance() && !this.baseRandom.isPredictionResistant()) {
                    throw new IllegalArgumentException("prediction resistance not available");
                }
            } else {
                throw new IllegalArgumentException("unrecognized DrbgParameters: " + String.valueOf(params.getClass()));
            }
            this.baseRandom.nextBytes(bytes, p.getAdditionalInput());
        }

        @Override
        protected void engineNextBytes(byte[] bytes) {
            this.baseRandom.nextBytes(bytes);
        }

        @Override
        protected byte[] engineGenerateSeed(int numBytes) {
            return this.baseRandom.generateSeed(numBytes);
        }

        @Override
        protected void engineReseed(SecureRandomParameters params) {
            if (params instanceof DrbgParameters.Reseed) {
                DrbgParameters.Reseed p = (DrbgParameters.Reseed)params;
                if (p.getPredictionResistance() && !this.baseRandom.isPredictionResistant()) {
                    throw new IllegalArgumentException("prediction resistance not available");
                }
                this.baseRandom.reseed(p.getAdditionalInput());
            } else {
                if (params != null) {
                    throw new IllegalArgumentException("unrecognized DrbgParameters: " + String.valueOf(params.getClass()));
                }
                this.baseRandom.reseed();
            }
        }

        @Override
        protected SecureRandomParameters engineGetParameters() {
            return this.params;
        }
    }
}

