/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.NativeServices;
import org.bouncycastle.crypto.OutputMACCalculator;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.FipsDH;
import org.bouncycastle.crypto.fips.FipsDRBG;
import org.bouncycastle.crypto.fips.FipsDSA;
import org.bouncycastle.crypto.fips.FipsEC;
import org.bouncycastle.crypto.fips.FipsEdEC;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsPBKD;
import org.bouncycastle.crypto.fips.FipsRSA;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsTripleDES;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class DumpInfo {
    private static final String[] classes = new String[]{FipsAES.class.getName(), FipsTripleDES.class.getName(), FipsDH.class.getName(), FipsSHS.class.getName(), FipsDRBG.class.getName(), FipsDSA.class.getName(), FipsEdEC.class.getName(), FipsEC.class.getName(), FipsKDF.class.getName(), FipsPBKD.class.getName(), FipsRSA.class.getName()};

    public static void main(String[] args) {
        if (args.length > 0) {
            if (args[0].equals("-verbose")) {
                System.out.print(DumpInfo.buildInfoString(true));
            } else if (args[0].equals("-c")) {
                System.out.println(Strings.fromByteArray(Hex.encode(FipsStatus.getModuleHMAC())));
                System.err.println("Generated new HMAC");
            } else if (args[0].equals("-a") && args.length > 1) {
                try {
                    JarFile jf = new JarFile(args[1]);
                    System.out.println(Strings.fromByteArray(Hex.encode(DumpInfo.calculateModuleHMAC(jf))));
                    System.err.println("Generated new HMAC for Jar file " + args[1]);
                }
                catch (IOException e) {
                    System.err.println("Unable to open Jar file " + args[1]);
                }
            } else {
                System.err.println("Invalid command line arguments.");
            }
        } else {
            System.out.print(DumpInfo.buildInfoString(false));
        }
    }

    public static String getInfoString(boolean verbose) {
        return DumpInfo.buildInfoString(verbose);
    }

    private static String buildInfoString(boolean all) {
        String[][] result;
        StringBuilder sBld = new StringBuilder();
        String newLine = System.lineSeparator();
        DumpInfo.runTests();
        sBld.append("Version Info: ");
        sBld.append(BouncyCastleFipsProvider.getInfoString());
        sBld.append(newLine);
        sBld.append("FIPS Ready Status: ");
        sBld.append(FipsStatus.getStatusMessage());
        sBld.append(newLine);
        NativeServices nativeServices = CryptoServicesRegistrar.getNativeServices();
        if (all || nativeServices.isEnabled()) {
            if (all || nativeServices.isSupported()) {
                sBld.append("Native Ready Status: ");
                sBld.append(nativeServices.getStatusMessage());
                sBld.append(newLine);
                sBld.append("Native Variant: ");
                sBld.append(nativeServices.getVariant());
                sBld.append(newLine);
                sBld.append("Native Build Date: ");
                sBld.append(nativeServices.getBuildDate());
                sBld.append(newLine);
            }
            if (nativeServices.isEnabled()) {
                sBld.append("Native Support: ");
                sBld.append(DumpInfo.getNativeFeatureString(nativeServices));
                sBld.append(newLine);
            }
        }
        if (all) {
            sBld.append(DumpInfo.getVerboseStatusMessage(nativeServices));
        }
        if (all && (result = nativeServices.getVariantSelectionMatrix()).length > 0) {
            sBld.append(newLine);
            sBld.append("CPU Features and Variant availability.");
            sBld.append(newLine);
            sBld.append("--------------------------------------------------------------------------------");
            sBld.append(newLine);
            sBld.append(DumpInfo.pad("Variant", 10));
            sBld.append(DumpInfo.pad("CPU features + or -:", 50));
            sBld.append(DumpInfo.pad("Supported", 20));
            sBld.append(newLine);
            sBld.append("--------------------------------------------------------------------------------");
            sBld.append(newLine);
            for (String[] parts : result) {
                String title = DumpInfo.pad(parts[0], 10);
                String cpuFeatures = "";
                for (int t = 1; t < parts.length - 1; ++t) {
                    cpuFeatures = cpuFeatures + parts[t];
                    cpuFeatures = cpuFeatures + " ";
                }
                cpuFeatures = DumpInfo.pad(cpuFeatures.trim(), 50);
                String status = parts[parts.length - 1];
                sBld.append(title);
                sBld.append(cpuFeatures);
                sBld.append(status);
                sBld.append(newLine);
            }
            sBld.append(newLine);
        }
        sBld.append("Module SHA-256 HMAC: " + Strings.fromByteArray(Hex.encode(FipsStatus.getModuleHMAC())));
        sBld.append(newLine);
        return sBld.toString();
    }

    private static String getVerboseStatusMessage(NativeServices nativeServices) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Native Libs Available: " + nativeServices.isSupported());
        pw.println("Native Libs Installed: " + nativeServices.isInstalled());
        pw.println("Native Status Message: " + nativeServices.getStatusMessage());
        pw.close();
        return sw.toString();
    }

    private static String getNativeFeatureString(NativeServices nativeServices) {
        return String.join((CharSequence)" ", nativeServices.getFeatureSet());
    }

    private static String pad(String left, int len) {
        StringBuilder sb = new StringBuilder();
        sb.append(left);
        for (int t = 0; t < len - left.length(); ++t) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private static byte[] calculateModuleHMAC(JarFile jarFile) {
        try {
            OutputMACCalculator hMacCalculator = new FipsSHS.MACOperatorFactory().createOutputMACCalculator((SymmetricKey)new SymmetricSecretKey(FipsSHS.Algorithm.SHA256_HMAC, Strings.toByteArray("Legion of the Bouncy Castle Inc.")), FipsSHS.SHA256_HMAC);
            UpdateOutputStream mOut = hMacCalculator.getMACStream();
            TreeMap<String, Object> index = new TreeMap<String, Object>();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (DumpInfo.skipEntry(jarEntry)) continue;
                index.put(jarEntry.getName(), jarEntry);
            }
            byte[] buf = new byte[8192];
            for (Map.Entry entry : index.entrySet()) {
                int n;
                JarEntry jarEntry = (JarEntry)entry.getValue();
                InputStream is = jarFile.getInputStream(jarEntry);
                byte[] encName = Strings.toUTF8ByteArray(jarEntry.getName());
                mOut.update((byte)91);
                mOut.update(encName, 0, encName.length);
                mOut.update(Pack.longToBigEndian(jarEntry.getSize()), 0, 8);
                mOut.update((byte)93);
                while ((n = is.read(buf, 0, buf.length)) != -1) {
                    mOut.update(buf, 0, n);
                }
                is.close();
            }
            mOut.update((byte)91);
            byte[] encName = Strings.toUTF8ByteArray("END");
            mOut.update(encName, 0, encName.length);
            mOut.update((byte)93);
            mOut.close();
            return hMacCalculator.getMAC();
        }
        catch (Exception e) {
            return new byte[32];
        }
    }

    private static boolean skipEntry(JarEntry jarEntry) {
        if (jarEntry.isDirectory() || jarEntry.getName().indexOf("module-info.class") > 0) {
            return true;
        }
        if (jarEntry.getName().startsWith("META-INF/")) {
            if (jarEntry.getName().contains("OSGI-INF/")) {
                return true;
            }
            if (jarEntry.getName().indexOf("versions/") < 0) {
                return true;
            }
        }
        return false;
    }

    private static void runTests() {
        for (String cls : classes) {
            if (FipsStatus.isErrorStatus()) continue;
            DumpInfo.loadClass(cls);
        }
        NativeServices nativeServices = CryptoServicesRegistrar.getNativeServices();
        if (nativeServices.isEnabled() && nativeServices.isSupported()) {
            SymmetricSecretKey aesKey = new SymmetricSecretKey(FipsAES.ALGORITHM, Hex.decode("000102030405060708090a0b0c0d0e0f"));
            FipsAES.OperatorFactory fact = new FipsAES.OperatorFactory();
            if (nativeServices.hasService("AES/ECB")) {
                fact.createOutputEncryptor((SymmetricKey)aesKey, FipsAES.ECB);
            }
            if (nativeServices.hasService("AES/CBC")) {
                fact.createOutputEncryptor((SymmetricKey)aesKey, FipsAES.CBC.withIV(Hex.decode("000102030405060708090a0b0c0d0e0f")));
            }
            if (nativeServices.hasService("AES/CFB")) {
                fact.createOutputEncryptor((SymmetricKey)aesKey, FipsAES.CFB128.withIV(Hex.decode("000102030405060708090a0b0c0d0e0f")));
            }
            if (nativeServices.hasService("AES/CTR")) {
                fact.createOutputEncryptor((SymmetricKey)aesKey, FipsAES.CTR.withIV(Hex.decode("000102030405060708090a0b0c0d0e0f")));
            }
            FipsAES.AEADOperatorFactory aeadFact = new FipsAES.AEADOperatorFactory();
            if (nativeServices.hasService("AES/GCM")) {
                aeadFact.createOutputAEADEncryptor((SymmetricKey)aesKey, FipsAES.GCM.withIV(Hex.decode("000102030405060708090a0b")));
            }
            if (nativeServices.hasService("SHA2")) {
                new FipsSHS.OperatorFactory<FipsSHS.Parameters>().createOutputDigestCalculator(FipsSHS.SHA256);
            }
            if (nativeServices.hasService("DRBG") || nativeServices.hasService("NRBG")) {
                CryptoServicesRegistrar.getDefaultEntropySourceProvider().get(256);
            }
        }
    }

    private static void loadClass(String className) {
        try {
            Class.forName(className);
        }
        catch (ExceptionInInitializerError e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to initialize module: " + e.getMessage(), e);
        }
    }
}

