/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.jcajce.spec.KTSKeySpec;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class KTSGenerateKeySpec
extends KTSKeySpec {
    private final PublicKey publicKey;
    private final SecureRandom random;

    private KTSGenerateKeySpec(PublicKey publicKey, String algorithmName, int keySize, SecureRandom random, String macAlgorithm, int macKeySizeInBits, AlgorithmParameterSpec parameterSpec, AlgorithmIdentifier kdfAlgorithm, byte[] otherInfo, byte[] salt) {
        super(algorithmName, keySize, macAlgorithm, macKeySizeInBits, parameterSpec, kdfAlgorithm, otherInfo, salt);
        this.publicKey = publicKey;
        this.random = random;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public SecureRandom getSecureRandom() {
        return this.random;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Builder {
        private final PublicKey publicKey;
        private final String algorithmName;
        private final int keySizeInBits;
        private String macAlgorithm;
        private int macKeySizeInBits;
        private SecureRandom random;
        private AlgorithmParameterSpec parameterSpec;
        private AlgorithmIdentifier kdfAlgorithm;
        private byte[] otherInfo;
        private byte[] salt;

        public Builder(PublicKey publicKey, String algorithmName, int keySizeInBits) {
            this(publicKey, algorithmName, keySizeInBits, null);
        }

        public Builder(PublicKey publicKey, String algorithmName, int keySizeInBits, byte[] otherInfo) {
            this.publicKey = publicKey;
            this.algorithmName = algorithmName;
            this.keySizeInBits = keySizeInBits;
            this.kdfAlgorithm = KTSKeySpec.createAlgId(KTSKeySpec.KDF3.withPRF(FipsKDF.AgreementKDFPRF.SHA256));
            this.otherInfo = KTSKeySpec.copyOtherInfo(otherInfo);
        }

        public Builder withSecureRandom(SecureRandom random) {
            this.random = random;
            return this;
        }

        public Builder withMac(String macAlgorithmName, int macKeySizeInBits) {
            this.macAlgorithm = macAlgorithmName;
            this.macKeySizeInBits = macKeySizeInBits;
            if (macAlgorithmName != null && macKeySizeInBits <= 0) {
                throw new IllegalArgumentException("macKeySizeInBits must be greater than zero");
            }
            return this;
        }

        public Builder withParameterSpec(AlgorithmParameterSpec parameterSpec) {
            this.parameterSpec = parameterSpec;
            return this;
        }

        public Builder withKdfAlgorithm(FipsKDF.AgreementKDFParametersBuilder kdfBuilder) {
            this.kdfAlgorithm = KTSKeySpec.createAlgId(kdfBuilder);
            return this;
        }

        public Builder withKdfAlgorithm(AlgorithmIdentifier kdfAlgorithm) {
            this.kdfAlgorithm = kdfAlgorithm;
            return this;
        }

        public Builder withKdfSalt(byte[] salt) {
            this.salt = salt;
            return this;
        }

        public KTSGenerateKeySpec build() {
            return new KTSGenerateKeySpec(this.publicKey, this.algorithmName, this.keySizeInBits, this.random, this.macAlgorithm, this.macKeySizeInBits, this.parameterSpec, this.kdfAlgorithm, this.otherInfo, this.salt);
        }
    }
}

