/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.io.IOException;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsEntropyConfig;
import org.bouncycastle.crypto.fips.FipsOutputXOFCalculator;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class EntropyUtil {
    public static byte[] generateSeed(EntropySource entropySource, int numBytes) {
        byte[] bytes = new byte[numBytes];
        byte[] xofKey = entropySource.getEntropy();
        if (numBytes * 8 <= entropySource.entropySize()) {
            byte[] ent = entropySource.getEntropy();
            System.arraycopy(ent, 0, bytes, 0, bytes.length);
        } else {
            int entSize = entropySource.entropySize() / 8;
            for (int i = 0; i < bytes.length; i += entSize) {
                byte[] ent = entropySource.getEntropy();
                if (ent.length <= bytes.length - i) {
                    System.arraycopy(ent, 0, bytes, i, ent.length);
                    continue;
                }
                System.arraycopy(ent, 0, bytes, i, bytes.length - i);
            }
        }
        FipsOutputXOFCalculator<FipsSHS.Parameters> calc = new FipsSHS.XOFOperatorFactory<FipsSHS.Parameters>().createOutputXOFCalculator(FipsSHS.SHAKE256);
        UpdateOutputStream fOut = calc.getFunctionStream();
        try {
            fOut.write(xofKey);
            fOut.write(bytes);
            fOut.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("failure in seed generator");
        }
        finally {
            Arrays.clear(xofKey);
            Arrays.clear(bytes);
        }
        calc.getFunctionOutput(bytes, 0, bytes.length);
        return bytes;
    }

    public static String isNotStuck(byte prev, byte[] current) {
        int C = FipsEntropyConfig.getStuckC();
        if (current.length < C) {
            throw new IllegalArgumentException("alpha value too large for entropy size");
        }
        int b = 1;
        byte a = prev;
        for (int i = 0; i != current.length; ++i) {
            byte x = current[i];
            if (x == a) {
                if (++b < C) continue;
                return "entropy source stuck";
            }
            a = x;
            b = 1;
        }
        return null;
    }

    public static String isProportionate(WindowStats stats, byte[] current) {
        try {
            for (int i = 0; i < current.length; ++i) {
                stats.check(current[i]);
            }
            return null;
        }
        catch (IllegalStateException e) {
            return e.getMessage();
        }
    }

    public static WindowStats createStats() {
        return new WindowStats(FipsEntropyConfig.getAdaptiveProportionateC(), FipsEntropyConfig.getAdaptiveProportionateW());
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class WindowStats {
        private final int W;
        private final int adptC;
        byte a;
        int i;
        int b;

        WindowStats(int adptC, int W) {
            this.adptC = adptC;
            this.W = W;
            this.i = W;
        }

        void incB() {
            ++this.b;
            if (this.b >= this.adptC) {
                throw new IllegalStateException("proportionate test failed");
            }
        }

        void check(byte sample) {
            if (this.i > this.W - 1) {
                this.reset(sample);
            } else if (this.a == sample) {
                this.incB();
            }
            ++this.i;
        }

        void reset(byte sample) {
            this.b = 1;
            this.i = 0;
            this.a = sample;
        }
    }
}

