/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.io;

import java.io.IOException;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.internal.Xof;
import org.bouncycastle.crypto.internal.io.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class XofOutputStream
extends UpdateOutputStream {
    private final String algorithmName;
    private final boolean isApprovedMode;
    protected Xof digest;

    public XofOutputStream(Xof digest) {
        this.algorithmName = digest.getAlgorithmName();
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.digest = digest;
    }

    @Override
    public void write(int b) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.update((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.update(b, off, len);
    }

    public final int getOutput(byte[] output, int off, int outLen) {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        return this.digest.doOutput(output, off, outLen);
    }

    public final int getFinalOutput(byte[] output, int off, int outLen) {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        return this.digest.doFinal(output, off, outLen);
    }

    public void reset() {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.reset();
    }
}

