/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.util.encoders.Hex;

class X931RNG {
    private static final long BLOCK64_RESEED_MAX = 32768L;
    private static final long BLOCK128_RESEED_MAX = 0x800000L;
    private static final int BLOCK64_MAX_BITS_REQUEST = 4096;
    private static final int BLOCK128_MAX_BITS_REQUEST = 262144;
    private static final Map<String, byte[][]> kats = new HashMap<String, byte[][]>();
    private BlockCipher engine;
    private EntropySource entropySource;
    private final byte[] DT;
    private final byte[] I;
    private final byte[] R;
    private byte[] V;
    private long reseedCounter = 1L;

    public X931RNG(BlockCipher engine, byte[] dateTimeVector, EntropySource entropySource) {
        this.engine = engine;
        this.entropySource = entropySource;
        this.DT = new byte[engine.getBlockSize()];
        System.arraycopy(dateTimeVector, 0, this.DT, 0, this.DT.length);
        this.I = new byte[engine.getBlockSize()];
        this.R = new byte[engine.getBlockSize()];
    }

    public int getBlockSize() {
        return this.engine.getBlockSize() * 8;
    }

    int generate(byte[] output, boolean predictionResistant) {
        if (this.R.length == 8) {
            if (this.reseedCounter > 32768L) {
                return -1;
            }
            if (X931RNG.isTooLarge(output, 512)) {
                throw new IllegalArgumentException("Number of bits per request limited to 4096");
            }
        } else {
            if (this.reseedCounter > 0x800000L) {
                return -1;
            }
            if (X931RNG.isTooLarge(output, 32768)) {
                throw new IllegalArgumentException("Number of bits per request limited to 262144");
            }
        }
        if (predictionResistant || this.V == null) {
            this.V = this.getEntropy();
        }
        int m = output.length / this.R.length;
        for (int i = 0; i < m; ++i) {
            this.engine.processBlock(this.DT, 0, this.I, 0);
            this.process(this.R, this.I, this.V);
            this.process(this.V, this.R, this.I);
            System.arraycopy(this.R, 0, output, i * this.R.length, this.R.length);
            this.increment(this.DT);
        }
        int bytesToCopy = output.length - m * this.R.length;
        if (bytesToCopy > 0) {
            this.engine.processBlock(this.DT, 0, this.I, 0);
            this.process(this.R, this.I, this.V);
            this.process(this.V, this.R, this.I);
            System.arraycopy(this.R, 0, output, m * this.R.length, bytesToCopy);
            this.increment(this.DT);
        }
        ++this.reseedCounter;
        return output.length * 8;
    }

    void reseed() {
        this.V = this.getEntropy();
        this.reseedCounter = 1L;
    }

    private byte[] getEntropy() {
        byte[] tmp = this.entropySource.getEntropy();
        if (tmp.length != this.engine.getBlockSize()) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return tmp;
    }

    private void process(byte[] res, byte[] a, byte[] b) {
        for (int i = 0; i != res.length; ++i) {
            res[i] = (byte)(a[i] ^ b[i]);
        }
        this.engine.processBlock(res, 0, res, 0);
    }

    private void increment(byte[] val) {
        int i = val.length - 1;
        while (i >= 0) {
            int n = i--;
            val[n] = (byte)(val[n] + 1);
            if (val[n] != 0) break;
        }
    }

    private static boolean isTooLarge(byte[] bytes, int maxBytes) {
        return bytes != null && bytes.length > maxBytes;
    }

    static {
        kats.put("AES", new byte[][]{Hex.decode("f7d36762b9915f1ed585eb8e91700eb2"), Hex.decode("259e67249288597a4d61e7c0e690afae"), Hex.decode("35cc0ea481fc8a4f5f05c7d4667233b2"), Hex.decode("15f013af5a8e9df9a8e37500edaeac43")});
        kats.put("DESede", new byte[][]{Hex.decode("ef16ec643e5db5892cbc6eabba310b3410e6f8759e3e382c"), Hex.decode("55df103deaf68dc4"), Hex.decode("96d872b9122c5e74"), Hex.decode("9c960bb9662ce6de")});
    }
}

