/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.EntropySourceProvider;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.FipsTripleDES;
import org.bouncycastle.crypto.general.ContinuousTestingEntropySource;
import org.bouncycastle.crypto.general.ContinuousTestingPseudoRNG;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralSecureRandom;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.X931PseudoRandom;
import org.bouncycastle.crypto.general.X931RNG;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.util.BasicEntropySourceProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public final class X931PRNG {
    public static final Base Triple_DES_168 = new Base(new GeneralAlgorithm("TRIPLEDES", (Enum)Variations.Triple_DES_168));
    public static final Base AES_128 = new Base(new GeneralAlgorithm("AES-128", (Enum)Variations.AES_128));
    public static final Base AES_192 = new Base(new GeneralAlgorithm("AES-192", (Enum)Variations.AES_192));
    public static final Base AES_256 = new Base(new GeneralAlgorithm("AES-256", (Enum)Variations.AES_256));

    private X931PRNG() {
    }

    public static class Builder {
        private final GeneralAlgorithm algorithm;
        private final SecureRandom random;
        private final EntropySourceProvider entropySourceProvider;
        private byte[] dateTimeVector;

        Builder(GeneralAlgorithm algorithm, SecureRandom random, EntropySourceProvider entropySourceProvider, byte[] dateTimeVector) {
            this.algorithm = algorithm;
            this.random = random;
            this.entropySourceProvider = entropySourceProvider;
            this.dateTimeVector = dateTimeVector;
        }

        public Builder setDateTimeVector(byte[] dateTimeVector) {
            this.dateTimeVector = Arrays.clone(dateTimeVector);
            return this;
        }

        public GeneralSecureRandom build(SymmetricKey key, boolean predictionResistant) {
            byte[] keyBytes;
            int keySizeInBits;
            BlockCipher engine;
            switch ((Variations)this.algorithm.basicVariation()) {
                case AES_128: {
                    engine = (BlockCipher)FipsRegister.getProvider(FipsAES.ALGORITHM).createEngine();
                    keySizeInBits = 128;
                    break;
                }
                case AES_192: {
                    engine = (BlockCipher)FipsRegister.getProvider(FipsAES.ALGORITHM).createEngine();
                    keySizeInBits = 192;
                    break;
                }
                case AES_256: {
                    engine = (BlockCipher)FipsRegister.getProvider(FipsAES.ALGORITHM).createEngine();
                    keySizeInBits = 256;
                    break;
                }
                case Triple_DES_168: {
                    engine = (BlockCipher)FipsRegister.getProvider(FipsTripleDES.ALGORITHM).createEngine();
                    keySizeInBits = 192;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown algorithm passed to build(): " + this.algorithm.getName());
                }
            }
            byte[] dtv = this.dateTimeVector;
            if (dtv == null) {
                dtv = new byte[engine.getBlockSize()];
                Pack.longToBigEndian(System.currentTimeMillis(), dtv, 0);
            }
            if (keySizeInBits != (keyBytes = PrivilegedUtils.getKeyBytes(key)).length * 8) {
                throw new IllegalKeyException("FIPS key not correct length - should be " + keyBytes.length + " bytes long.");
            }
            engine.init(true, new KeyParameterImpl(keyBytes));
            ContinuousTestingEntropySource entropySource = new ContinuousTestingEntropySource(this.entropySourceProvider.get(engine.getBlockSize() * 8));
            return new GeneralSecureRandom(this.random, this.getAlgorithmName(engine, keySizeInBits), new ContinuousTestingPseudoRNG(new X931PseudoRandom(new X931RNG(engine, dtv, entropySource)), null), entropySource, predictionResistant);
        }

        String getAlgorithmName(BlockCipher blockCipher, int keySizeInBits) {
            if (blockCipher.getAlgorithmName().equals("AES")) {
                return "X9.31-PRNG-" + blockCipher.getAlgorithmName() + keySizeInBits;
            }
            return "X9.31-PRNG-3KEY-TDES";
        }
    }

    public static class Base
    implements Parameters {
        private final GeneralAlgorithm algorithm;

        private Base(GeneralAlgorithm algorithm) {
            this.algorithm = algorithm;
        }

        public Builder fromDefaultEntropy() {
            SecureRandom entropySource = new SecureRandom();
            return new Builder(this.algorithm, entropySource, new BasicEntropySourceProvider(entropySource, false), null);
        }

        public Builder fromEntropySource(SecureRandom entropySource, boolean predictionResistant) {
            return new Builder(this.algorithm, entropySource, new BasicEntropySourceProvider(entropySource, predictionResistant), null);
        }

        public Builder fromEntropySource(EntropySourceProvider entropySourceProvider) {
            return new Builder(this.algorithm, null, entropySourceProvider, null);
        }

        @Override
        public Algorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    private static enum Variations {
        Triple_DES_168,
        AES_128,
        AES_192,
        AES_256;

    }
}

