/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParameters;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.general.CipherKeyGenerator;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedMACOperatorFactory;
import org.bouncycastle.crypto.general.GuardedSymmetricKeyGenerator;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.SipHashEngine;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.macs.TruncatingMac;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SipHash {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("SipHash");
    public static final GeneralAlgorithm SIPHASH_2_4 = new GeneralAlgorithm("SipHash-2-4");
    public static final GeneralAlgorithm SIPHASH_4_8 = new GeneralAlgorithm("SipHash-4-8");

    private SipHash() {
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey key, Parameters parameters) {
        ValidatedSymmetricKey vKey = PrivilegedUtils.getValidatedKey(key);
        int keyLength = vKey.getKeySizeInBits();
        if (SipHash.invalidKeySize(keyLength)) {
            throw new IllegalKeyException("SipHash key must be of length 128 bits");
        }
        Algorithm algorithm = key.getAlgorithm();
        if (algorithm != ALGORITHM && algorithm != parameters.getAlgorithm()) {
            throw new IllegalKeyException("Key not for appropriate algorithm");
        }
        return vKey;
    }

    private static boolean invalidKeySize(int keyLength) {
        return keyLength != 128;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class MACOperatorFactory
    extends GuardedMACOperatorFactory<AuthParameters> {
        @Override
        protected Mac createMAC(SymmetricKey key, AuthParameters parameters) {
            Mac mac = this.getMac(parameters);
            if (mac.getMacSize() != (parameters.getMACSizeInBits() + 7) / 8) {
                mac = new TruncatingMac(mac, parameters.macSizeInBits);
            }
            mac.init(Utils.getKeyParameter(SipHash.validateKey(key, parameters)));
            return mac;
        }

        private Mac getMac(AuthParameters parameters) {
            SipHashEngine mac;
            if (parameters.getAlgorithm() == SIPHASH_2_4) {
                mac = new SipHashEngine(2, 4);
            } else if (parameters.getAlgorithm() == SIPHASH_4_8) {
                mac = new SipHashEngine(4, 8);
            } else {
                throw new IllegalArgumentException("Unknown algorithm passed to createMAC: " + parameters.getAlgorithm());
            }
            return mac;
        }

        @Override
        protected int calculateMACSize(AuthParameters parameters) {
            return this.getMac(parameters).getMacSize();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final GeneralAlgorithm algorithm;
        private final SecureRandom random;

        public KeyGenerator(SecureRandom random) {
            this(ALGORITHM, random);
        }

        public KeyGenerator(GeneralAlgorithm algorithm, SecureRandom random) {
            this.algorithm = algorithm;
            this.random = random;
        }

        @Override
        public SymmetricKey doGenerateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, 128));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class AuthParameters
    extends GeneralParameters<GeneralAlgorithm>
    implements AuthenticationParameters<AuthParameters> {
        private final int macSizeInBits;

        private AuthParameters(GeneralAlgorithm algorithm, int macSizeInBits) {
            super(algorithm);
            this.macSizeInBits = macSizeInBits;
        }

        public AuthParameters() {
            this(SIPHASH_2_4);
        }

        public AuthParameters(GeneralAlgorithm algorithm) {
            this(algorithm, 64);
        }

        @Override
        public int getMACSizeInBits() {
            return this.macSizeInBits;
        }

        @Override
        public AuthParameters withMACSize(int macSizeInBits) {
            return new AuthParameters((GeneralAlgorithm)this.getAlgorithm(), macSizeInBits);
        }
    }
}

