/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.general.SerpentEngineBase;
import org.bouncycastle.util.Pack;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class SerpentEngine
extends SerpentEngineBase {
    SerpentEngine() {
    }

    @Override
    protected int[] makeWorkingKey(byte[] key) throws IllegalArgumentException {
        int i;
        int[] kPad = new int[16];
        int off = 0;
        int length = 0;
        off = 0;
        while (off + 4 < key.length) {
            kPad[length++] = Pack.littleEndianToInt(key, off);
            off += 4;
        }
        if (off % 4 == 0) {
            kPad[length++] = Pack.littleEndianToInt(key, off);
            if (length < 8) {
                kPad[length] = 1;
            }
        } else {
            throw new IllegalArgumentException("key must be a multiple of 4 bytes");
        }
        int amount = 132;
        int[] w = new int[amount];
        for (i = 8; i < 16; ++i) {
            kPad[i] = SerpentEngine.rotateLeft(kPad[i - 8] ^ kPad[i - 5] ^ kPad[i - 3] ^ kPad[i - 1] ^ 0x9E3779B9 ^ i - 8, 11);
        }
        System.arraycopy(kPad, 8, w, 0, 8);
        for (i = 8; i < amount; ++i) {
            w[i] = SerpentEngine.rotateLeft(w[i - 8] ^ w[i - 5] ^ w[i - 3] ^ w[i - 1] ^ 0x9E3779B9 ^ i, 11);
        }
        this.sb3(w[0], w[1], w[2], w[3]);
        w[0] = this.X0;
        w[1] = this.X1;
        w[2] = this.X2;
        w[3] = this.X3;
        this.sb2(w[4], w[5], w[6], w[7]);
        w[4] = this.X0;
        w[5] = this.X1;
        w[6] = this.X2;
        w[7] = this.X3;
        this.sb1(w[8], w[9], w[10], w[11]);
        w[8] = this.X0;
        w[9] = this.X1;
        w[10] = this.X2;
        w[11] = this.X3;
        this.sb0(w[12], w[13], w[14], w[15]);
        w[12] = this.X0;
        w[13] = this.X1;
        w[14] = this.X2;
        w[15] = this.X3;
        this.sb7(w[16], w[17], w[18], w[19]);
        w[16] = this.X0;
        w[17] = this.X1;
        w[18] = this.X2;
        w[19] = this.X3;
        this.sb6(w[20], w[21], w[22], w[23]);
        w[20] = this.X0;
        w[21] = this.X1;
        w[22] = this.X2;
        w[23] = this.X3;
        this.sb5(w[24], w[25], w[26], w[27]);
        w[24] = this.X0;
        w[25] = this.X1;
        w[26] = this.X2;
        w[27] = this.X3;
        this.sb4(w[28], w[29], w[30], w[31]);
        w[28] = this.X0;
        w[29] = this.X1;
        w[30] = this.X2;
        w[31] = this.X3;
        this.sb3(w[32], w[33], w[34], w[35]);
        w[32] = this.X0;
        w[33] = this.X1;
        w[34] = this.X2;
        w[35] = this.X3;
        this.sb2(w[36], w[37], w[38], w[39]);
        w[36] = this.X0;
        w[37] = this.X1;
        w[38] = this.X2;
        w[39] = this.X3;
        this.sb1(w[40], w[41], w[42], w[43]);
        w[40] = this.X0;
        w[41] = this.X1;
        w[42] = this.X2;
        w[43] = this.X3;
        this.sb0(w[44], w[45], w[46], w[47]);
        w[44] = this.X0;
        w[45] = this.X1;
        w[46] = this.X2;
        w[47] = this.X3;
        this.sb7(w[48], w[49], w[50], w[51]);
        w[48] = this.X0;
        w[49] = this.X1;
        w[50] = this.X2;
        w[51] = this.X3;
        this.sb6(w[52], w[53], w[54], w[55]);
        w[52] = this.X0;
        w[53] = this.X1;
        w[54] = this.X2;
        w[55] = this.X3;
        this.sb5(w[56], w[57], w[58], w[59]);
        w[56] = this.X0;
        w[57] = this.X1;
        w[58] = this.X2;
        w[59] = this.X3;
        this.sb4(w[60], w[61], w[62], w[63]);
        w[60] = this.X0;
        w[61] = this.X1;
        w[62] = this.X2;
        w[63] = this.X3;
        this.sb3(w[64], w[65], w[66], w[67]);
        w[64] = this.X0;
        w[65] = this.X1;
        w[66] = this.X2;
        w[67] = this.X3;
        this.sb2(w[68], w[69], w[70], w[71]);
        w[68] = this.X0;
        w[69] = this.X1;
        w[70] = this.X2;
        w[71] = this.X3;
        this.sb1(w[72], w[73], w[74], w[75]);
        w[72] = this.X0;
        w[73] = this.X1;
        w[74] = this.X2;
        w[75] = this.X3;
        this.sb0(w[76], w[77], w[78], w[79]);
        w[76] = this.X0;
        w[77] = this.X1;
        w[78] = this.X2;
        w[79] = this.X3;
        this.sb7(w[80], w[81], w[82], w[83]);
        w[80] = this.X0;
        w[81] = this.X1;
        w[82] = this.X2;
        w[83] = this.X3;
        this.sb6(w[84], w[85], w[86], w[87]);
        w[84] = this.X0;
        w[85] = this.X1;
        w[86] = this.X2;
        w[87] = this.X3;
        this.sb5(w[88], w[89], w[90], w[91]);
        w[88] = this.X0;
        w[89] = this.X1;
        w[90] = this.X2;
        w[91] = this.X3;
        this.sb4(w[92], w[93], w[94], w[95]);
        w[92] = this.X0;
        w[93] = this.X1;
        w[94] = this.X2;
        w[95] = this.X3;
        this.sb3(w[96], w[97], w[98], w[99]);
        w[96] = this.X0;
        w[97] = this.X1;
        w[98] = this.X2;
        w[99] = this.X3;
        this.sb2(w[100], w[101], w[102], w[103]);
        w[100] = this.X0;
        w[101] = this.X1;
        w[102] = this.X2;
        w[103] = this.X3;
        this.sb1(w[104], w[105], w[106], w[107]);
        w[104] = this.X0;
        w[105] = this.X1;
        w[106] = this.X2;
        w[107] = this.X3;
        this.sb0(w[108], w[109], w[110], w[111]);
        w[108] = this.X0;
        w[109] = this.X1;
        w[110] = this.X2;
        w[111] = this.X3;
        this.sb7(w[112], w[113], w[114], w[115]);
        w[112] = this.X0;
        w[113] = this.X1;
        w[114] = this.X2;
        w[115] = this.X3;
        this.sb6(w[116], w[117], w[118], w[119]);
        w[116] = this.X0;
        w[117] = this.X1;
        w[118] = this.X2;
        w[119] = this.X3;
        this.sb5(w[120], w[121], w[122], w[123]);
        w[120] = this.X0;
        w[121] = this.X1;
        w[122] = this.X2;
        w[123] = this.X3;
        this.sb4(w[124], w[125], w[126], w[127]);
        w[124] = this.X0;
        w[125] = this.X1;
        w[126] = this.X2;
        w[127] = this.X3;
        this.sb3(w[128], w[129], w[130], w[131]);
        w[128] = this.X0;
        w[129] = this.X1;
        w[130] = this.X2;
        w[131] = this.X3;
        return w;
    }

    @Override
    protected void encryptBlock(byte[] input, int inOff, byte[] output, int outOff) {
        this.X0 = Pack.littleEndianToInt(input, inOff);
        this.X1 = Pack.littleEndianToInt(input, inOff + 4);
        this.X2 = Pack.littleEndianToInt(input, inOff + 8);
        this.X3 = Pack.littleEndianToInt(input, inOff + 12);
        this.sb0(this.wKey[0] ^ this.X0, this.wKey[1] ^ this.X1, this.wKey[2] ^ this.X2, this.wKey[3] ^ this.X3);
        this.LT();
        this.sb1(this.wKey[4] ^ this.X0, this.wKey[5] ^ this.X1, this.wKey[6] ^ this.X2, this.wKey[7] ^ this.X3);
        this.LT();
        this.sb2(this.wKey[8] ^ this.X0, this.wKey[9] ^ this.X1, this.wKey[10] ^ this.X2, this.wKey[11] ^ this.X3);
        this.LT();
        this.sb3(this.wKey[12] ^ this.X0, this.wKey[13] ^ this.X1, this.wKey[14] ^ this.X2, this.wKey[15] ^ this.X3);
        this.LT();
        this.sb4(this.wKey[16] ^ this.X0, this.wKey[17] ^ this.X1, this.wKey[18] ^ this.X2, this.wKey[19] ^ this.X3);
        this.LT();
        this.sb5(this.wKey[20] ^ this.X0, this.wKey[21] ^ this.X1, this.wKey[22] ^ this.X2, this.wKey[23] ^ this.X3);
        this.LT();
        this.sb6(this.wKey[24] ^ this.X0, this.wKey[25] ^ this.X1, this.wKey[26] ^ this.X2, this.wKey[27] ^ this.X3);
        this.LT();
        this.sb7(this.wKey[28] ^ this.X0, this.wKey[29] ^ this.X1, this.wKey[30] ^ this.X2, this.wKey[31] ^ this.X3);
        this.LT();
        this.sb0(this.wKey[32] ^ this.X0, this.wKey[33] ^ this.X1, this.wKey[34] ^ this.X2, this.wKey[35] ^ this.X3);
        this.LT();
        this.sb1(this.wKey[36] ^ this.X0, this.wKey[37] ^ this.X1, this.wKey[38] ^ this.X2, this.wKey[39] ^ this.X3);
        this.LT();
        this.sb2(this.wKey[40] ^ this.X0, this.wKey[41] ^ this.X1, this.wKey[42] ^ this.X2, this.wKey[43] ^ this.X3);
        this.LT();
        this.sb3(this.wKey[44] ^ this.X0, this.wKey[45] ^ this.X1, this.wKey[46] ^ this.X2, this.wKey[47] ^ this.X3);
        this.LT();
        this.sb4(this.wKey[48] ^ this.X0, this.wKey[49] ^ this.X1, this.wKey[50] ^ this.X2, this.wKey[51] ^ this.X3);
        this.LT();
        this.sb5(this.wKey[52] ^ this.X0, this.wKey[53] ^ this.X1, this.wKey[54] ^ this.X2, this.wKey[55] ^ this.X3);
        this.LT();
        this.sb6(this.wKey[56] ^ this.X0, this.wKey[57] ^ this.X1, this.wKey[58] ^ this.X2, this.wKey[59] ^ this.X3);
        this.LT();
        this.sb7(this.wKey[60] ^ this.X0, this.wKey[61] ^ this.X1, this.wKey[62] ^ this.X2, this.wKey[63] ^ this.X3);
        this.LT();
        this.sb0(this.wKey[64] ^ this.X0, this.wKey[65] ^ this.X1, this.wKey[66] ^ this.X2, this.wKey[67] ^ this.X3);
        this.LT();
        this.sb1(this.wKey[68] ^ this.X0, this.wKey[69] ^ this.X1, this.wKey[70] ^ this.X2, this.wKey[71] ^ this.X3);
        this.LT();
        this.sb2(this.wKey[72] ^ this.X0, this.wKey[73] ^ this.X1, this.wKey[74] ^ this.X2, this.wKey[75] ^ this.X3);
        this.LT();
        this.sb3(this.wKey[76] ^ this.X0, this.wKey[77] ^ this.X1, this.wKey[78] ^ this.X2, this.wKey[79] ^ this.X3);
        this.LT();
        this.sb4(this.wKey[80] ^ this.X0, this.wKey[81] ^ this.X1, this.wKey[82] ^ this.X2, this.wKey[83] ^ this.X3);
        this.LT();
        this.sb5(this.wKey[84] ^ this.X0, this.wKey[85] ^ this.X1, this.wKey[86] ^ this.X2, this.wKey[87] ^ this.X3);
        this.LT();
        this.sb6(this.wKey[88] ^ this.X0, this.wKey[89] ^ this.X1, this.wKey[90] ^ this.X2, this.wKey[91] ^ this.X3);
        this.LT();
        this.sb7(this.wKey[92] ^ this.X0, this.wKey[93] ^ this.X1, this.wKey[94] ^ this.X2, this.wKey[95] ^ this.X3);
        this.LT();
        this.sb0(this.wKey[96] ^ this.X0, this.wKey[97] ^ this.X1, this.wKey[98] ^ this.X2, this.wKey[99] ^ this.X3);
        this.LT();
        this.sb1(this.wKey[100] ^ this.X0, this.wKey[101] ^ this.X1, this.wKey[102] ^ this.X2, this.wKey[103] ^ this.X3);
        this.LT();
        this.sb2(this.wKey[104] ^ this.X0, this.wKey[105] ^ this.X1, this.wKey[106] ^ this.X2, this.wKey[107] ^ this.X3);
        this.LT();
        this.sb3(this.wKey[108] ^ this.X0, this.wKey[109] ^ this.X1, this.wKey[110] ^ this.X2, this.wKey[111] ^ this.X3);
        this.LT();
        this.sb4(this.wKey[112] ^ this.X0, this.wKey[113] ^ this.X1, this.wKey[114] ^ this.X2, this.wKey[115] ^ this.X3);
        this.LT();
        this.sb5(this.wKey[116] ^ this.X0, this.wKey[117] ^ this.X1, this.wKey[118] ^ this.X2, this.wKey[119] ^ this.X3);
        this.LT();
        this.sb6(this.wKey[120] ^ this.X0, this.wKey[121] ^ this.X1, this.wKey[122] ^ this.X2, this.wKey[123] ^ this.X3);
        this.LT();
        this.sb7(this.wKey[124] ^ this.X0, this.wKey[125] ^ this.X1, this.wKey[126] ^ this.X2, this.wKey[127] ^ this.X3);
        Pack.intToLittleEndian(this.wKey[128] ^ this.X0, output, outOff);
        Pack.intToLittleEndian(this.wKey[129] ^ this.X1, output, outOff + 4);
        Pack.intToLittleEndian(this.wKey[130] ^ this.X2, output, outOff + 8);
        Pack.intToLittleEndian(this.wKey[131] ^ this.X3, output, outOff + 12);
    }

    @Override
    protected void decryptBlock(byte[] input, int inOff, byte[] output, int outOff) {
        this.X0 = this.wKey[128] ^ Pack.littleEndianToInt(input, inOff);
        this.X1 = this.wKey[129] ^ Pack.littleEndianToInt(input, inOff + 4);
        this.X2 = this.wKey[130] ^ Pack.littleEndianToInt(input, inOff + 8);
        this.X3 = this.wKey[131] ^ Pack.littleEndianToInt(input, inOff + 12);
        this.ib7(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[124];
        this.X1 ^= this.wKey[125];
        this.X2 ^= this.wKey[126];
        this.X3 ^= this.wKey[127];
        this.inverseLT();
        this.ib6(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[120];
        this.X1 ^= this.wKey[121];
        this.X2 ^= this.wKey[122];
        this.X3 ^= this.wKey[123];
        this.inverseLT();
        this.ib5(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[116];
        this.X1 ^= this.wKey[117];
        this.X2 ^= this.wKey[118];
        this.X3 ^= this.wKey[119];
        this.inverseLT();
        this.ib4(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[112];
        this.X1 ^= this.wKey[113];
        this.X2 ^= this.wKey[114];
        this.X3 ^= this.wKey[115];
        this.inverseLT();
        this.ib3(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[108];
        this.X1 ^= this.wKey[109];
        this.X2 ^= this.wKey[110];
        this.X3 ^= this.wKey[111];
        this.inverseLT();
        this.ib2(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[104];
        this.X1 ^= this.wKey[105];
        this.X2 ^= this.wKey[106];
        this.X3 ^= this.wKey[107];
        this.inverseLT();
        this.ib1(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[100];
        this.X1 ^= this.wKey[101];
        this.X2 ^= this.wKey[102];
        this.X3 ^= this.wKey[103];
        this.inverseLT();
        this.ib0(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[96];
        this.X1 ^= this.wKey[97];
        this.X2 ^= this.wKey[98];
        this.X3 ^= this.wKey[99];
        this.inverseLT();
        this.ib7(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[92];
        this.X1 ^= this.wKey[93];
        this.X2 ^= this.wKey[94];
        this.X3 ^= this.wKey[95];
        this.inverseLT();
        this.ib6(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[88];
        this.X1 ^= this.wKey[89];
        this.X2 ^= this.wKey[90];
        this.X3 ^= this.wKey[91];
        this.inverseLT();
        this.ib5(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[84];
        this.X1 ^= this.wKey[85];
        this.X2 ^= this.wKey[86];
        this.X3 ^= this.wKey[87];
        this.inverseLT();
        this.ib4(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[80];
        this.X1 ^= this.wKey[81];
        this.X2 ^= this.wKey[82];
        this.X3 ^= this.wKey[83];
        this.inverseLT();
        this.ib3(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[76];
        this.X1 ^= this.wKey[77];
        this.X2 ^= this.wKey[78];
        this.X3 ^= this.wKey[79];
        this.inverseLT();
        this.ib2(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[72];
        this.X1 ^= this.wKey[73];
        this.X2 ^= this.wKey[74];
        this.X3 ^= this.wKey[75];
        this.inverseLT();
        this.ib1(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[68];
        this.X1 ^= this.wKey[69];
        this.X2 ^= this.wKey[70];
        this.X3 ^= this.wKey[71];
        this.inverseLT();
        this.ib0(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[64];
        this.X1 ^= this.wKey[65];
        this.X2 ^= this.wKey[66];
        this.X3 ^= this.wKey[67];
        this.inverseLT();
        this.ib7(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[60];
        this.X1 ^= this.wKey[61];
        this.X2 ^= this.wKey[62];
        this.X3 ^= this.wKey[63];
        this.inverseLT();
        this.ib6(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[56];
        this.X1 ^= this.wKey[57];
        this.X2 ^= this.wKey[58];
        this.X3 ^= this.wKey[59];
        this.inverseLT();
        this.ib5(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[52];
        this.X1 ^= this.wKey[53];
        this.X2 ^= this.wKey[54];
        this.X3 ^= this.wKey[55];
        this.inverseLT();
        this.ib4(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[48];
        this.X1 ^= this.wKey[49];
        this.X2 ^= this.wKey[50];
        this.X3 ^= this.wKey[51];
        this.inverseLT();
        this.ib3(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[44];
        this.X1 ^= this.wKey[45];
        this.X2 ^= this.wKey[46];
        this.X3 ^= this.wKey[47];
        this.inverseLT();
        this.ib2(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[40];
        this.X1 ^= this.wKey[41];
        this.X2 ^= this.wKey[42];
        this.X3 ^= this.wKey[43];
        this.inverseLT();
        this.ib1(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[36];
        this.X1 ^= this.wKey[37];
        this.X2 ^= this.wKey[38];
        this.X3 ^= this.wKey[39];
        this.inverseLT();
        this.ib0(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[32];
        this.X1 ^= this.wKey[33];
        this.X2 ^= this.wKey[34];
        this.X3 ^= this.wKey[35];
        this.inverseLT();
        this.ib7(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[28];
        this.X1 ^= this.wKey[29];
        this.X2 ^= this.wKey[30];
        this.X3 ^= this.wKey[31];
        this.inverseLT();
        this.ib6(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[24];
        this.X1 ^= this.wKey[25];
        this.X2 ^= this.wKey[26];
        this.X3 ^= this.wKey[27];
        this.inverseLT();
        this.ib5(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[20];
        this.X1 ^= this.wKey[21];
        this.X2 ^= this.wKey[22];
        this.X3 ^= this.wKey[23];
        this.inverseLT();
        this.ib4(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[16];
        this.X1 ^= this.wKey[17];
        this.X2 ^= this.wKey[18];
        this.X3 ^= this.wKey[19];
        this.inverseLT();
        this.ib3(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[12];
        this.X1 ^= this.wKey[13];
        this.X2 ^= this.wKey[14];
        this.X3 ^= this.wKey[15];
        this.inverseLT();
        this.ib2(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[8];
        this.X1 ^= this.wKey[9];
        this.X2 ^= this.wKey[10];
        this.X3 ^= this.wKey[11];
        this.inverseLT();
        this.ib1(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[4];
        this.X1 ^= this.wKey[5];
        this.X2 ^= this.wKey[6];
        this.X3 ^= this.wKey[7];
        this.inverseLT();
        this.ib0(this.X0, this.X1, this.X2, this.X3);
        Pack.intToLittleEndian(this.X0 ^ this.wKey[0], output, outOff);
        Pack.intToLittleEndian(this.X1 ^ this.wKey[1], output, outOff + 4);
        Pack.intToLittleEndian(this.X2 ^ this.wKey[2], output, outOff + 8);
        Pack.intToLittleEndian(this.X3 ^ this.wKey[3], output, outOff + 12);
    }
}

