/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class PrivilegedUtils {
    PrivilegedUtils() {
    }

    static byte[] getKeyBytes(final SymmetricKey sKey) {
        return AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

            @Override
            public byte[] run() {
                return sKey.getKeyBytes();
            }
        });
    }

    static ValidatedSymmetricKey getValidatedKey(SymmetricKey key) {
        return new ValidatedSymmetricKey(key.getAlgorithm(), PrivilegedUtils.getKeyBytes(key));
    }
}

