/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.general.CipherKeyGenerator;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class Poly1305KeyGenerator
extends CipherKeyGenerator {
    private static final byte R_MASK_LOW_2 = -4;
    private static final byte R_MASK_HIGH_4 = 15;

    Poly1305KeyGenerator() {
    }

    @Override
    public void init(KeyGenerationParameters param) {
        super.init(new KeyGenerationParameters(param.getRandom(), 256));
    }

    @Override
    public byte[] generateKey() {
        byte[] key = super.generateKey();
        Poly1305KeyGenerator.clamp(key);
        return key;
    }

    static byte[] clamp(byte[] key) {
        if (key.length != 32) {
            throw new IllegalArgumentException("Poly1305 key must be 256 bits.");
        }
        key[3] = (byte)(key[3] & 0xF);
        key[7] = (byte)(key[7] & 0xF);
        key[11] = (byte)(key[11] & 0xF);
        key[15] = (byte)(key[15] & 0xF);
        key[4] = (byte)(key[4] & 0xFFFFFFFC);
        key[8] = (byte)(key[8] & 0xFFFFFFFC);
        key[12] = (byte)(key[12] & 0xFFFFFFFC);
        return key;
    }
}

