/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.util.logging.Logger;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.fips.FipsEntropyConfig;
import org.bouncycastle.crypto.fips.FipsOperationError;
import org.bouncycastle.crypto.util.EntropyUtil;
import org.bouncycastle.util.Arrays;

class ContinuousTestingEntropySource
implements EntropySource {
    private static final Logger LOG = Logger.getLogger(ContinuousTestingEntropySource.class.getName());
    private final EntropySource entropySource;
    private byte[] buf;
    private EntropyUtil.WindowStats windStats;

    public ContinuousTestingEntropySource(EntropySource entropySource) {
        this.entropySource = entropySource;
    }

    @Override
    public boolean isPredictionResistant() {
        return this.entropySource.isPredictionResistant();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getEntropy() {
        ContinuousTestingEntropySource continuousTestingEntropySource = this;
        synchronized (continuousTestingEntropySource) {
            byte[] nxt;
            String msg;
            if (this.buf == null) {
                this.buf = this.entropySource.getEntropy();
                this.windStats = EntropyUtil.createStats();
                String msg2 = EntropyUtil.isProportionate(this.windStats, this.buf);
                if (msg2 != null) {
                    throw new IllegalStateException(msg2);
                }
            }
            int retries = 0;
            int maxRetries = FipsEntropyConfig.getMaxRetries();
            do {
                ++retries;
                nxt = this.entropySource.getEntropy();
                msg = EntropyUtil.isNotStuck(this.buf[this.buf.length - 1], nxt);
                if (msg != null) {
                    LOG.warning(msg);
                }
                if ((msg = EntropyUtil.isProportionate(this.windStats, nxt)) != null) {
                    LOG.warning(msg);
                }
                if (!Arrays.areEqual(nxt, this.buf)) continue;
                msg = "Duplicate block detected in EntropySource output";
                LOG.warning(msg);
            } while (msg != null && retries <= maxRetries);
            if (retries > maxRetries) {
                FipsOperationError.flag(msg);
            }
            System.arraycopy(nxt, 0, this.buf, 0, this.buf.length);
            return nxt;
        }
    }

    @Override
    public int entropySize() {
        return this.entropySource.entropySize();
    }
}

