/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.fips.RSAEngine;
import org.bouncycastle.crypto.internal.AsymmetricBlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.crypto.internal.params.RsaKeyParameters;
import org.bouncycastle.crypto.internal.params.RsaPrivateCrtKeyParameters;
import org.bouncycastle.util.BigIntegers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class RsaBlindedEngine
implements AsymmetricBlockCipher {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private final RSAEngine core;
    private RsaKeyParameters key;
    private SecureRandom random;

    RsaBlindedEngine(RSAEngine core) {
        this.core = core;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        this.core.init(forEncryption, param);
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (RsaKeyParameters)rParam.getParameters();
            this.random = rParam.getRandom();
        } else {
            this.key = (RsaKeyParameters)param;
            if (this.key.isPrivate()) {
                throw new IllegalArgumentException("No random provided where one required.");
            }
        }
    }

    @Override
    public int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    @Override
    public int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        BigInteger result;
        if (this.key == null) {
            throw new IllegalStateException("RSA engine not initialised");
        }
        BigInteger input = this.core.convertInput(in, inOff, inLen);
        if (input.compareTo(this.key.getModulus()) >= 0) {
            throw new DataLengthException("input to RSA engine out of range");
        }
        if (this.key instanceof RsaPrivateCrtKeyParameters) {
            RsaPrivateCrtKeyParameters k = (RsaPrivateCrtKeyParameters)this.key;
            BigInteger e = k.getPublicExponent();
            if (e != null) {
                BigInteger rInv;
                BigInteger m = k.getModulus();
                BigInteger r = BigIntegers.createRandomInRange(ONE, m.subtract(ONE), this.random);
                BigInteger blindedInput = r.modPow(e, m).multiply(input).mod(m);
                BigInteger blindedResult = this.core.processBlock(blindedInput);
                result = blindedResult.multiply(rInv = BigIntegers.modOddInverse(m, r)).mod(m);
                if (!input.equals(result.modPow(e, m))) {
                    throw new IllegalStateException("RSA engine faulty decryption/signing detected");
                }
            } else {
                result = this.core.processBlock(input);
            }
        } else {
            result = this.core.processBlock(input);
        }
        return this.core.convertOutput(result);
    }
}

