/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.crypto.fips.FipsNativeServices;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.LoaderUtils;
import org.bouncycastle.crypto.fips.NativeLibIdentity;
import org.bouncycastle.crypto.fips.VariantSelector;
import org.bouncycastle.crypto.internal.ExtendedDigest;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.io.Streams;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class NativeLoader {
    private static final Logger LOG = Logger.getLogger(NativeLoader.class.getName());
    public static final String BCFIPS_LIB_CPU_VARIANT = "org.bouncycastle.native.cpu_variant";
    public static final String LIB_INSTALL_DIR = "org.bouncycastle.native.loader.install_dir";
    private static final AtomicBoolean nativeLibsAvailableForSystem = new AtomicBoolean(false);
    private static final AtomicBoolean nativeInstalled = new AtomicBoolean(false);
    private static final AtomicBoolean nativeEnabled = new AtomicBoolean(false);
    private static final AtomicReference<String> nativeStatusMessage = new AtomicReference<String>("Driver load not attempted");
    private static final AtomicReference<String> selectedVariant = new AtomicReference<Object>(null);
    private static final FipsNativeServices nativeServices = new FipsNativeServices();

    NativeLoader() {
    }

    static synchronized boolean isNativeInstalled() {
        return nativeInstalled.get();
    }

    static synchronized boolean isNativeAvailable() {
        return nativeLibsAvailableForSystem.get() && nativeInstalled.get() && nativeEnabled.get();
    }

    static synchronized void setNativeEnabled(boolean enabled) {
        nativeEnabled.set(enabled);
    }

    static synchronized String getNativeStatusMessage() {
        return nativeStatusMessage.get();
    }

    static synchronized String getSelectedVariant() {
        return selectedVariant.get();
    }

    static String getFile(String path) {
        String value;
        try {
            InputStream in = NativeLoader.class.getResourceAsStream(path);
            value = Strings.fromByteArray(Streams.readAll(in));
            in.close();
        }
        catch (Exception ex) {
            return null;
        }
        return value;
    }

    static List<String> loadVariantsDeps(String depFile, String libName) {
        String data = NativeLoader.getFile(depFile);
        if (data == null) {
            return Collections.emptyList();
        }
        ArrayList<String> out = new ArrayList<String>();
        for (String line : data.split("\n")) {
            String[] parts = (line = line.trim()).split(":");
            if (!parts[0].trim().equals(libName)) continue;
            out.add(parts[1].trim());
        }
        return Collections.unmodifiableList(out);
    }

    static File installLib(String name, String libPathSegment, String jarPath, File bcLibPath, Set<File> filesInInstallLocation) throws Exception {
        String libLocalName = System.mapLibraryName(name);
        List<String> deps = NativeLoader.loadVariantsDeps(jarPath + "/deps.list", libLocalName);
        for (String dep : deps) {
            filesInInstallLocation.remove(LoaderUtils.extractFromClasspath(bcLibPath, jarPath + "/" + dep, dep));
        }
        File libToLoad = LoaderUtils.extractFromClasspath(bcLibPath, libPathSegment + "/" + libLocalName, libLocalName);
        filesInInstallLocation.remove(libToLoad);
        return libToLoad;
    }

    static synchronized void loadDriver() {
        File bcFipsLibPath;
        String forcedVariant = Properties.getPropertyValue(BCFIPS_LIB_CPU_VARIANT);
        if ("java".equals(forcedVariant)) {
            nativeEnabled.set(false);
            nativeInstalled.set(false);
            nativeStatusMessage.set("java support only");
            return;
        }
        String arch_ = Strings.toLowerCase(Properties.getPropertyValue("os.arch", ""));
        String os_ = Strings.toLowerCase(Properties.getPropertyValue("os.name", ""));
        String platform = null;
        String arch = null;
        if (os_.contains("linux")) {
            platform = "linux";
        }
        if (platform == null) {
            nativeStatusMessage.set("OS '" + os_ + "' is not supported.");
            return;
        }
        if (arch_.contains("x86") || arch_.contains("amd") && arch_.contains("64")) {
            arch = "x86_64";
        }
        if (arch == null) {
            nativeStatusMessage.set("architecture '" + arch_ + "' is not supported");
            return;
        }
        try {
            String fixedInstallDirProp = Properties.getPropertyValue(LIB_INSTALL_DIR);
            if (fixedInstallDirProp != null) {
                String version = "BouncyCastle Security Provider (FIPS edition) v2.1.2".substring("BouncyCastle Security Provider (FIPS edition) v2.1.2".lastIndexOf(118) + 1);
                bcFipsLibPath = LoaderUtils.createVersionedTempDir(fixedInstallDirProp, version);
            } else {
                bcFipsLibPath = LoaderUtils.createTempDir("bc-fips-jni");
            }
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "temporary file creation failed", ex);
            nativeInstalled.set(false);
            nativeStatusMessage.set("temporary file creation failed: " + ex.getMessage());
            bcFipsLibPath = null;
        }
        if (bcFipsLibPath == null) {
            return;
        }
        HashSet<File> filesInInstallLocation = new HashSet<File>();
        Collections.addAll(filesInInstallLocation, bcFipsLibPath.listFiles());
        String jarDir = String.format("/native/%s/%s", platform, arch);
        String probeLibInJarPath = String.format("/native/%s/%s/probe", platform, arch);
        InputStream tmpIn = NativeLoader.class.getResourceAsStream(probeLibInJarPath + "/" + System.mapLibraryName("bc-probe"));
        if (tmpIn == null) {
            String msg = String.format("platform '%s' and architecture '%s' are not supported", platform, arch);
            LOG.log(Level.FINE, msg);
            nativeStatusMessage.set(msg);
            nativeInstalled.set(false);
            return;
        }
        try {
            tmpIn.close();
        }
        catch (IOException msg) {
            // empty catch block
        }
        if (forcedVariant != null) {
            selectedVariant.set(forcedVariant);
        } else {
            try {
                final File lib = NativeLoader.installLib("bc-probe", probeLibInJarPath, jarDir, bcFipsLibPath, filesInInstallLocation);
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        System.load(lib.getAbsolutePath());
                        return new Object();
                    }
                });
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "probe lib failed to load", ex);
                nativeStatusMessage.set("probe lib failed to load " + ex.getMessage());
                nativeInstalled.set(false);
                return;
            }
            try {
                selectedVariant.set(VariantSelector.getBestVariantName());
            }
            catch (Throwable ex) {
                LOG.log(Level.FINE, "probe lib failed return a variant", ex);
                nativeStatusMessage.set("probe lib failed return a variant " + ex.getMessage());
                nativeInstalled.set(false);
                return;
            }
        }
        if (selectedVariant.get().equals("none")) {
            nativeEnabled.set(false);
            nativeInstalled.set(false);
            String msg = "probe returned no suitable CPU features, java support only";
            LOG.log(Level.FINE, msg);
            nativeStatusMessage.set(msg);
            return;
        }
        String variantPathInJar = String.format("/native/%s/%s/%s", platform, arch, selectedVariant);
        try {
            final File lib = NativeLoader.installLib("bc-fips-" + selectedVariant, variantPathInJar, jarDir, bcFipsLibPath, filesInInstallLocation);
            if (!filesInInstallLocation.isEmpty()) {
                StringBuilder sBld = new StringBuilder();
                for (File f : filesInInstallLocation) {
                    if (sBld.length() != 0) {
                        sBld.append(",");
                    }
                    sBld.append(f.getName());
                }
                String msg = String.format("unexpected files in %s: %s", bcFipsLibPath, sBld);
                LOG.log(Level.FINE, msg);
                nativeStatusMessage.set(msg);
                nativeInstalled.set(false);
                return;
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.load(lib.getAbsolutePath());
                    return new Object();
                }
            });
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "native capabilities lib failed to load", ex);
            nativeStatusMessage.set("native capabilities lib failed to load " + ex.getMessage());
            nativeInstalled.set(false);
            return;
        }
        if (!selectedVariant.get().equals(NativeLibIdentity.getLibraryIdent())) {
            String msg = String.format("loaded native library variant is %s but the requested library variant is %s", NativeLibIdentity.getLibraryIdent(), selectedVariant);
            LOG.fine(msg);
            nativeStatusMessage.set(msg);
            nativeInstalled.set(false);
            return;
        }
        nativeLibsAvailableForSystem.set(true);
        nativeStatusMessage.set("successfully loaded");
        LOG.fine("successfully loaded");
        nativeInstalled.set(true);
        nativeEnabled.set(true);
    }

    public static boolean isNativeLibsAvailableForSystem() {
        return nativeLibsAvailableForSystem.get();
    }

    static FipsNativeServices getNativeServices() {
        return nativeServices;
    }

    static boolean hasNativeService(String feature) {
        return NativeLoader.isNativeAvailable() && nativeServices.hasService(feature);
    }

    private static byte[] takeSHA256Digest(InputStream in) {
        try {
            int len;
            byte[] buf = new byte[65535];
            ExtendedDigest dig = FipsSHS.createBaseDigest(FipsSHS.Algorithm.SHA256);
            while ((len = in.read(buf)) >= 0) {
                dig.update(buf, 0, len);
            }
            byte[] res = new byte[dig.getDigestSize()];
            dig.doFinal(res, 0);
            return res;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static boolean isNativeEnabled() {
        return nativeEnabled.get();
    }
}

