/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.DSAOutputVerifier;
import org.bouncycastle.crypto.fips.FipsOutputValidator;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.io.DigestOutputStream;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DSAOutputValidator<T extends Parameters>
extends FipsOutputValidator<T> {
    private final DSA dsa;
    private final Digest digest;
    private final BigInteger[] rs;
    private final T parameter;

    DSAOutputValidator(DSA dsa, Digest digest, T parameter, byte[] signature) throws InvalidSignatureException {
        this.dsa = dsa;
        this.digest = digest;
        this.parameter = parameter;
        try {
            this.rs = DSAOutputVerifier.decode(signature);
        }
        catch (Exception e) {
            throw new InvalidSignatureException("Unable to process signature: " + e.getMessage(), e);
        }
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public UpdateOutputStream getValidatingStream() {
        return new DigestOutputStream(this.digest);
    }

    @Override
    public boolean isValidated() {
        byte[] m = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(m, 0);
        return this.dsa.verifySignature(m, this.rs[0], this.rs[1]);
    }
}

