/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.KMAC;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.DerivationFunction;
import org.bouncycastle.crypto.internal.DerivationParameters;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.params.KDFParameters;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ConcatenationKDFGenerator
implements DerivationFunction {
    private final Mac mac;
    private Digest digest;
    private byte[] shared;
    private byte[] otherInfo;
    private int hLen;

    public ConcatenationKDFGenerator(Digest digest) {
        this.digest = digest;
        this.mac = null;
        this.hLen = digest.getDigestSize();
    }

    public ConcatenationKDFGenerator(Mac mac) {
        this.mac = mac;
        this.digest = null;
        this.hLen = mac.getMacSize();
    }

    @Override
    public void init(DerivationParameters param) {
        if (param instanceof KDFParameters) {
            KDFParameters p = (KDFParameters)param;
            this.shared = p.getSharedSecret();
            this.otherInfo = p.getIV();
            if (this.mac != null) {
                byte[] salt = p.getSalt();
                if (p.getSalt() == null) {
                    if (this.mac instanceof HMac) {
                        salt = new byte[((HMac)this.mac).getUnderlyingDigest().getByteLength()];
                    } else if (this.mac instanceof KMAC) {
                        salt = new byte[((KMAC)this.mac).getByteLength() - 4];
                    } else {
                        throw new IllegalArgumentException("cannot recognise MAC");
                    }
                }
                this.mac.init(new KeyParameterImpl(salt));
            }
        } else {
            throw new IllegalArgumentException("KDF parameters required for KDF generator");
        }
    }

    public Digest getDigest() {
        return this.digest;
    }

    private void ItoOSP(int i, byte[] sp) {
        sp[0] = (byte)(i >>> 24);
        sp[1] = (byte)(i >>> 16);
        sp[2] = (byte)(i >>> 8);
        sp[3] = (byte)(i >>> 0);
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        if (this.digest != null) {
            return this.digestGenerateBytes(out, outOff, len);
        }
        return this.macGenerateBytes(out, outOff, len);
    }

    public int digestGenerateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        if (out.length - len < outOff) {
            throw new DataLengthException("output buffer too small");
        }
        byte[] hashBuf = new byte[this.hLen];
        byte[] C = new byte[4];
        int counter = 1;
        int outputLen = 0;
        this.digest.reset();
        if (len > this.hLen) {
            do {
                this.ItoOSP(counter, C);
                this.digest.update(C, 0, C.length);
                this.digest.update(this.shared, 0, this.shared.length);
                if (this.otherInfo != null) {
                    this.digest.update(this.otherInfo, 0, this.otherInfo.length);
                }
                this.digest.doFinal(hashBuf, 0);
                System.arraycopy(hashBuf, 0, out, outOff + outputLen, this.hLen);
                outputLen += this.hLen;
            } while (counter++ < len / this.hLen);
        }
        if (outputLen < len) {
            this.ItoOSP(counter, C);
            this.digest.update(C, 0, C.length);
            this.digest.update(this.shared, 0, this.shared.length);
            if (this.otherInfo != null) {
                this.digest.update(this.otherInfo, 0, this.otherInfo.length);
            }
            this.digest.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, out, outOff + outputLen, len - outputLen);
        }
        return len;
    }

    private int macGenerateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        if (out.length - len < outOff) {
            throw new DataLengthException("output buffer too small");
        }
        byte[] hashBuf = new byte[this.hLen];
        byte[] C = new byte[4];
        int counter = 1;
        int outputLen = 0;
        this.mac.reset();
        if (this.mac instanceof KMAC) {
            this.ItoOSP(counter, C);
            this.mac.update(C, 0, C.length);
            this.mac.update(this.shared, 0, this.shared.length);
            if (this.otherInfo != null) {
                this.mac.update(this.otherInfo, 0, this.otherInfo.length);
            }
            return ((KMAC)this.mac).doFinal(out, outOff, len);
        }
        if (len > this.hLen) {
            do {
                this.ItoOSP(counter, C);
                this.mac.update(C, 0, C.length);
                this.mac.update(this.shared, 0, this.shared.length);
                if (this.otherInfo != null) {
                    this.mac.update(this.otherInfo, 0, this.otherInfo.length);
                }
                this.mac.doFinal(hashBuf, 0);
                System.arraycopy(hashBuf, 0, out, outOff + outputLen, this.hLen);
                outputLen += this.hLen;
            } while (counter++ < len / this.hLen);
        }
        if (outputLen < len) {
            this.ItoOSP(counter, C);
            this.mac.update(C, 0, C.length);
            this.mac.update(this.shared, 0, this.shared.length);
            if (this.otherInfo != null) {
                this.mac.update(this.otherInfo, 0, this.otherInfo.length);
            }
            this.mac.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, out, outOff + outputLen, len - outputLen);
        }
        return len;
    }
}

