/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class WrappedByteArrayOutputStream
extends OutputStream {
    private byte[] buf;
    private int start;
    private int offset;
    private boolean copied = false;

    public void setBuffer(byte[] output) {
        this.setBuffer(output, 0);
    }

    public void setBuffer(byte[] output, int outputOffset) {
        this.buf = output;
        this.start = outputOffset;
        this.offset = outputOffset;
    }

    @Override
    public void write(byte[] in) throws IOException {
        System.arraycopy(in, 0, this.buf, this.offset, in.length);
        this.offset += in.length;
    }

    @Override
    public void write(byte[] in, int inOff, int inLen) throws IOException {
        System.arraycopy(in, inOff, this.buf, this.offset, inLen);
        this.offset += inLen;
    }

    @Override
    public void write(int in) throws IOException {
        this.buf[this.offset++] = 0;
    }

    public int size() {
        return this.offset - this.start;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public void moveOffset(int delta) {
        this.offset += delta;
        if (this.offset < this.start || this.offset > this.buf.length) {
            throw new IllegalStateException("offset outside of buffer range");
        }
    }

    public byte[] toTrimmedByteArray() {
        if (this.size() != this.buf.length) {
            byte[] rv = new byte[this.size()];
            System.arraycopy(this.buf, this.start, rv, 0, rv.length);
            this.copied = true;
            return rv;
        }
        return this.buf;
    }

    public void erase() {
        if (this.copied) {
            Arrays.clear(this.buf);
            this.copied = false;
        }
    }

    public int getOffset() {
        return this.offset;
    }
}

