/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.jcajce.spec.PrfUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PBKDF2ParameterSpec
extends PBEParameterSpec {
    private static final AlgorithmIdentifier defaultPRF = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, DERNull.INSTANCE);
    private final int keySize;
    private final AlgorithmIdentifier prf;

    public PBKDF2ParameterSpec(byte[] salt, int iterationCount, int keySize) {
        this(salt, iterationCount, keySize, defaultPRF);
    }

    public PBKDF2ParameterSpec(byte[] salt, int iterationCount, int keySize, DigestAlgorithm prfAlgorithm) {
        this(salt, iterationCount, keySize, PrfUtils.getAlgorithmIdentifier(prfAlgorithm));
    }

    public PBKDF2ParameterSpec(byte[] salt, int iterationCount, int keySize, AlgorithmIdentifier prf) {
        super(salt, iterationCount);
        if (keySize % 8 != 0) {
            throw new IllegalArgumentException("keySize must be a multiple of 8");
        }
        this.keySize = keySize;
        this.prf = prf;
    }

    public boolean isDefaultPrf() {
        return defaultPRF.equals(this.prf);
    }

    public int getKeySize() {
        return this.keySize;
    }

    public AlgorithmIdentifier getPrf() {
        return this.prf;
    }
}

