/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import java.security.spec.ECParameterSpec;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.jcajce.spec.ECUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ECDomainParameterSpec
extends ECParameterSpec {
    private ECDomainParameters parameters;

    public ECDomainParameterSpec(ECDomainParameters parameters) {
        this(parameters, ECUtil.convertToSpec(parameters));
    }

    public ECDomainParameterSpec(ECParameterSpec parameterSpec) {
        this(ECUtil.convertFromSpec(parameterSpec), parameterSpec);
    }

    public ECDomainParameters getDomainParameters() {
        return this.parameters;
    }

    private ECDomainParameterSpec(ECDomainParameters parameters, ECParameterSpec ecParameterSpec) {
        super(ecParameterSpec.getCurve(), ecParameterSpec.getGenerator(), ecParameterSpec.getOrder(), ecParameterSpec.getCofactor());
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (o instanceof ECDomainParameterSpec) {
            ECDomainParameterSpec other = (ECDomainParameterSpec)o;
            return this.parameters.equals(other.parameters);
        }
        return false;
    }

    public int hashCode() {
        return this.parameters.hashCode();
    }

    public String toString() {
        if (this.parameters instanceof NamedECDomainParameters) {
            return ((NamedECDomainParameters)this.parameters).getID().getId();
        }
        return super.toString();
    }
}

