/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DHUParameterSpec
implements AlgorithmParameterSpec {
    private final PublicKey ephemeralPublicKey;
    private final PrivateKey ephemeralPrivateKey;
    private final PublicKey otherPartyEphemeralKey;
    private final AlgorithmParameterSpec kdfParameterSpec;

    public DHUParameterSpec(PublicKey ephemeralPublicKey, PrivateKey ephemeralPrivateKey, PublicKey otherPartyEphemeralKey, AlgorithmParameterSpec kdfParameterSpec) {
        if (ephemeralPrivateKey == null) {
            throw new IllegalArgumentException("ephemeral private key cannot be null");
        }
        if (otherPartyEphemeralKey == null) {
            throw new IllegalArgumentException("other party ephemeral key cannot be null");
        }
        this.ephemeralPublicKey = ephemeralPublicKey;
        this.ephemeralPrivateKey = ephemeralPrivateKey;
        this.otherPartyEphemeralKey = otherPartyEphemeralKey;
        this.kdfParameterSpec = kdfParameterSpec;
    }

    public DHUParameterSpec(PublicKey ephemeralPublicKey, PrivateKey ephemeralPrivateKey, PublicKey otherPartyEphemeralKey, byte[] userKeyingMaterial) {
        this(ephemeralPublicKey, ephemeralPrivateKey, otherPartyEphemeralKey, userKeyingMaterial != null ? new UserKeyingMaterialSpec(userKeyingMaterial) : null);
    }

    public DHUParameterSpec(PublicKey ephemeralPublicKey, PrivateKey ephemeralPrivateKey, PublicKey otherPartyEphemeralKey) {
        this(ephemeralPublicKey, ephemeralPrivateKey, otherPartyEphemeralKey, (AlgorithmParameterSpec)null);
    }

    public DHUParameterSpec(KeyPair ephemeralKeyPair, PublicKey otherPartyEphemeralKey, byte[] userKeyingMaterial) {
        this(ephemeralKeyPair.getPublic(), ephemeralKeyPair.getPrivate(), otherPartyEphemeralKey, userKeyingMaterial);
    }

    public DHUParameterSpec(PrivateKey ephemeralPrivateKey, PublicKey otherPartyEphemeralKey, byte[] userKeyingMaterial) {
        this(null, ephemeralPrivateKey, otherPartyEphemeralKey, userKeyingMaterial);
    }

    public DHUParameterSpec(PrivateKey ephemeralPrivateKey, PublicKey otherPartyEphemeralKey, AlgorithmParameterSpec kdfParameterSpec) {
        this(null, ephemeralPrivateKey, otherPartyEphemeralKey, kdfParameterSpec);
    }

    public DHUParameterSpec(KeyPair ephemeralKeyPair, PublicKey otherPartyEphemeralKey) {
        this(ephemeralKeyPair.getPublic(), ephemeralKeyPair.getPrivate(), otherPartyEphemeralKey, (AlgorithmParameterSpec)null);
    }

    public DHUParameterSpec(PrivateKey ephemeralPrivateKey, PublicKey otherPartyEphemeralKey) {
        this(null, ephemeralPrivateKey, otherPartyEphemeralKey, (AlgorithmParameterSpec)null);
    }

    public PrivateKey getEphemeralPrivateKey() {
        return this.ephemeralPrivateKey;
    }

    public PublicKey getEphemeralPublicKey() {
        return this.ephemeralPublicKey;
    }

    public PublicKey getOtherPartyEphemeralKey() {
        return this.otherPartyEphemeralKey;
    }

    public byte[] getUserKeyingMaterial() {
        if (this.kdfParameterSpec instanceof UserKeyingMaterialSpec) {
            return ((UserKeyingMaterialSpec)this.kdfParameterSpec).getUserKeyingMaterial();
        }
        return null;
    }

    public AlgorithmParameterSpec getKdfParameterSpec() {
        return this.kdfParameterSpec;
    }
}

