/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import java.math.BigInteger;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import org.bouncycastle.crypto.asymmetric.DHValidationParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DHDomainParameterSpec
extends DHParameterSpec {
    private final BigInteger q;
    private final BigInteger j;
    private final DHValidationParameters validationParameters;
    private final int m;

    public DHDomainParameterSpec(DHDomainParameters domainParameters) {
        this(domainParameters.getP(), domainParameters.getQ(), domainParameters.getG(), domainParameters.getJ(), domainParameters.getM(), domainParameters.getL(), domainParameters.getValidationParameters());
    }

    public DHDomainParameterSpec(BigInteger p, BigInteger q, BigInteger g) {
        this(p, q, g, null, 0, null);
    }

    public DHDomainParameterSpec(BigInteger p, BigInteger q, BigInteger g, int l) {
        this(p, q, g, null, l, null);
    }

    public DHDomainParameterSpec(BigInteger p, BigInteger q, BigInteger g, BigInteger j, int l, DHValidationParameters validationParameters) {
        this(p, q, g, j, 0, l, validationParameters);
    }

    public DHDomainParameterSpec(BigInteger p, BigInteger q, BigInteger g, BigInteger j, int m, int l, DHValidationParameters validationParameters) {
        super(p, g, l);
        this.q = q;
        this.j = j;
        this.m = m;
        this.validationParameters = validationParameters;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getJ() {
        return this.j;
    }

    public int getM() {
        return this.m;
    }

    public DHValidationParameters getValidationParameters() {
        return this.validationParameters;
    }

    public DHDomainParameters getDomainParameters() {
        return new DHDomainParameters(this.getP(), this.q, this.getG(), this.m, this.getL(), this.j, this.validationParameters);
    }
}

