/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPrivateKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.util.Strings;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvRSAPrivateCrtKey
implements Destroyable,
RSAPrivateKey,
RSAPrivateCrtKey,
ProvKey<AsymmetricRSAPrivateKey> {
    static final long serialVersionUID = 7834723820638524718L;
    private transient AsymmetricRSAPrivateKey baseKey;

    ProvRSAPrivateCrtKey(Algorithm algorithm, RSAPrivateCrtKey key) {
        this.baseKey = new AsymmetricRSAPrivateKey(algorithm, key.getModulus(), key.getPublicExponent(), key.getPrivateExponent(), key.getPrimeP(), key.getPrimeQ(), key.getPrimeExponentP(), key.getPrimeExponentQ(), key.getCrtCoefficient());
    }

    ProvRSAPrivateCrtKey(Algorithm algorithm, RSAPrivateCrtKeySpec keySpec) {
        this.baseKey = new AsymmetricRSAPrivateKey(algorithm, keySpec.getModulus(), keySpec.getPublicExponent(), keySpec.getPrivateExponent(), keySpec.getPrimeP(), keySpec.getPrimeQ(), keySpec.getPrimeExponentP(), keySpec.getPrimeExponentQ(), keySpec.getCrtCoefficient());
    }

    ProvRSAPrivateCrtKey(AsymmetricRSAPrivateKey key) {
        this.baseKey = key;
    }

    @Override
    public AsymmetricRSAPrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this.baseKey);
        return this.baseKey;
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this.baseKey);
        return "PKCS#8";
    }

    @Override
    public String getAlgorithm() {
        KeyUtil.checkDestroyed(this.baseKey);
        if ("RSA/PSS".equals(this.baseKey.getAlgorithm().getName())) {
            return "RSASSA-PSS";
        }
        return "RSA";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.baseKey.getPrivateExponent();
    }

    @Override
    public BigInteger getModulus() {
        return this.baseKey.getModulus();
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.baseKey.getPublicExponent();
    }

    @Override
    public BigInteger getPrimeP() {
        return this.baseKey.getP();
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.baseKey.getQ();
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return this.baseKey.getDP();
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return this.baseKey.getDQ();
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.baseKey.getQInv();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProvRSAPrivateCrtKey)) {
            return false;
        }
        ProvRSAPrivateCrtKey other = (ProvRSAPrivateCrtKey)o;
        return this.baseKey.equals(other.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Algorithm alg = (Algorithm)in.readObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricRSAPrivateKey(alg, enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        out.defaultWriteObject();
        out.writeObject(this.baseKey.getAlgorithm());
        out.writeObject(this.getEncoded());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String nl = Strings.lineSeparator();
        if (this.isDestroyed()) {
            buf.append("RSA Private CRT Key [DESTROYED]").append(nl);
        } else {
            buf.append("RSA Private CRT Key [").append(KeyUtil.generateFingerPrint(this.getModulus())).append("]").append(",[").append(KeyUtil.generateExponentFingerprint(this.getPublicExponent())).append("]").append(nl);
            buf.append("             modulus: ").append(this.getModulus().toString(16)).append(nl);
            buf.append("     public exponent: ").append(this.getPublicExponent().toString(16)).append(nl);
        }
        return buf.toString();
    }
}

