/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.OutputSigner;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SignatureOperatorFactory;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.AsymmetricLMSPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricLMSPublicKey;
import org.bouncycastle.crypto.fips.FipsLMS;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.ProvLMSPrivateKey;
import org.bouncycastle.jcajce.provider.ProvLMSPublicKey;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.LMSHSSKeyGenParameterSpec;
import org.bouncycastle.jcajce.spec.LMSKeyGenParameterSpec;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ProvLMS
extends AsymmetricAlgorithmProvider {
    private static final Map<String, String> generalAttributes = new HashMap<String, String>();
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.asymmetric.lms.";
    private static final PublicKeyConverter<AsymmetricLMSPublicKey> lmsPublicKeyConverter;
    private static final PrivateKeyConverter<AsymmetricLMSPrivateKey> lmsPrivateKeyConverter;

    ProvLMS() {
    }

    @Override
    void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("KeyFactory.LMS", "org.bouncycastle.jcajce.provider.asymmetric.lms.KeyFactorySpi$LMS", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyFactorySpi("LMS");
            }
        });
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            provider.addAlgorithmImplementation("KeyPairGenerator.LMS", "org.bouncycastle.jcajce.provider.asymmetric.lms.KeyPairGenerator", new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object constructorParameter) {
                    return new KeyPairGeneratorSpi(provider);
                }
            }));
        }
        provider.addAlgorithmImplementation("Signature.LMS", "org.bouncycastle.jcajce.provider.asymmetric.lms.Signature$LMS", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new LMSSignatureSpi(provider, new FipsLMS.OperatorFactory(), lmsPublicKeyConverter, lmsPrivateKeyConverter, FipsLMS.SIG);
            }
        });
        provider.addAlias("Signature", "LMS", PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            this.registerOid(provider, PKCSObjectIdentifiers.id_alg_hss_lms_hashsig, "LMS", new KeyFactorySpi("LMS"));
        } else {
            this.registerKeyFactoryOid(provider, PKCSObjectIdentifiers.id_alg_hss_lms_hashsig, "LMS", new KeyFactorySpi("LMS"));
        }
    }

    static {
        generalAttributes.put("SupportedKeyClasses", "org.bouncycastle.interfaces.LMSKey");
        generalAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
        lmsPublicKeyConverter = new PublicKeyConverter<AsymmetricLMSPublicKey>(){

            @Override
            public AsymmetricLMSPublicKey convertKey(Algorithm algorithm, PublicKey key) throws InvalidKeyException {
                if (key instanceof ProvLMSPublicKey) {
                    return ((ProvLMSPublicKey)key).getBaseKey();
                }
                try {
                    return new AsymmetricLMSPublicKey(Utils.getKeyEncoding(key));
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Cannot identify LMS public key: " + e.getMessage(), e);
                }
            }
        };
        lmsPrivateKeyConverter = new PrivateKeyConverter<AsymmetricLMSPrivateKey>(){

            @Override
            public AsymmetricLMSPrivateKey convertKey(Algorithm algorithm, PrivateKey key) throws InvalidKeyException {
                if (key instanceof ProvLMSPrivateKey) {
                    return ((ProvLMSPrivateKey)key).getBaseKey();
                }
                try {
                    return new AsymmetricLMSPrivateKey(PrivateKeyInfo.getInstance(Utils.getKeyEncoding(key)));
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Cannot identify LMS private key: " + e.getMessage(), e);
                }
            }
        };
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class LMSSignatureSpi
    extends SignatureSpi
    implements PKCSObjectIdentifiers,
    X509ObjectIdentifiers {
        private static final byte TRAILER_IMPLICIT = -68;
        private final SignatureOperatorFactory operatorFactory;
        private final PublicKeyConverter publicKeyConverter;
        private final PrivateKeyConverter privateKeyConverter;
        private final BouncyCastleFipsProvider fipsProvider;
        private final AlgorithmParameterSpec originalSpec;
        protected Parameters parameters;
        protected OutputVerifier verifier;
        protected OutputSigner signer;
        protected UpdateOutputStream dataStream;
        protected AlgorithmParameters engineParams;
        protected AlgorithmParameterSpec paramSpec;
        protected AsymmetricKey key;
        protected boolean isInitState = true;

        protected LMSSignatureSpi(BouncyCastleFipsProvider fipsProvider, SignatureOperatorFactory operatorFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, Parameters parameters) {
            this.fipsProvider = fipsProvider;
            this.operatorFactory = operatorFactory;
            this.publicKeyConverter = publicKeyConverter;
            this.privateKeyConverter = privateKeyConverter;
            this.parameters = parameters;
            this.originalSpec = null;
        }

        @Override
        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            this.key = this.publicKeyConverter.convertKey(this.parameters.getAlgorithm(), publicKey);
            this.initVerify();
            this.isInitState = true;
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            this.key = this.privateKeyConverter.convertKey(this.parameters.getAlgorithm(), privateKey);
            if (((AsymmetricLMSPrivateKey)this.key).getUsagesRemaining() == 0L) {
                throw new InvalidKeyException("private key exhausted");
            }
            this.appRandom = this.fipsProvider.getDefaultSecureRandom();
            this.isInitState = true;
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
            this.key = this.privateKeyConverter.convertKey(this.parameters.getAlgorithm(), privateKey);
            this.appRandom = random != null ? random : this.fipsProvider.getDefaultSecureRandom();
            this.isInitState = true;
        }

        @Override
        protected void engineUpdate(byte b) throws SignatureException {
            if (this.isInitState && this.key instanceof AsymmetricLMSPrivateKey) {
                this.initSign();
            }
            this.isInitState = false;
            this.dataStream.update(b);
        }

        @Override
        protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
            if (this.isInitState && this.key instanceof AsymmetricLMSPrivateKey) {
                this.initSign();
            }
            this.isInitState = false;
            this.dataStream.update(b, off, len);
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            if (this.isInitState && this.key instanceof AsymmetricLMSPrivateKey) {
                this.initSign();
            }
            try {
                this.isInitState = true;
                return this.signer.getSignature();
            }
            catch (Exception e) {
                throw new SignatureException(e.toString(), e);
            }
        }

        @Override
        protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
            try {
                this.isInitState = true;
                return this.verifier.isVerified(sigBytes);
            }
            catch (Exception e) {
                throw new SignatureException(e.toString(), e);
            }
        }

        @Override
        protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("no ParameterSpec supported");
        }

        private void initVerify() {
            this.verifier = this.operatorFactory.createVerifier((AsymmetricPublicKey)this.key, this.parameters);
            this.dataStream = this.verifier.getVerifyingStream();
        }

        private void initSign() throws SignatureException {
            try {
                this.signer = Utils.addRandomIfNeeded(this.operatorFactory.createSigner((AsymmetricPrivateKey)this.key, this.parameters), this.appRandom);
                this.dataStream = this.signer.getSigningStream();
            }
            catch (Exception e) {
                throw new SignatureException(e.getMessage(), e);
            }
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return this.engineParams;
        }

        @Override
        protected void engineSetParameter(String param, Object value) {
            throw new UnsupportedOperationException("SetParameter unsupported");
        }

        @Override
        protected Object engineGetParameter(String param) {
            throw new UnsupportedOperationException("GetParameter unsupported");
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class KeyPairGeneratorSpi
    extends KeyPairGenerator {
        private final BouncyCastleFipsProvider provider;
        FipsLMS.KeyGenParameters param;
        FipsLMS.KeyPairGenerator engine;
        SecureRandom random;
        boolean initialised = false;

        public KeyPairGeneratorSpi(BouncyCastleFipsProvider provider) {
            super("LMS");
            this.provider = provider;
        }

        @Override
        public void initialize(int strength) {
            this.initialize(strength, this.provider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            throw new UnsupportedOperationException("use AlgorithmParameterSpec");
        }

        @Override
        public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            this.initialize(params, this.provider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params instanceof LMSKeyGenParameterSpec) {
                LMSKeyGenParameterSpec lmsParams = (LMSKeyGenParameterSpec)params;
                this.param = new FipsLMS.KeyGenParameters(lmsParams.getKeyParams());
                this.engine = new FipsLMS.KeyPairGenerator(this.param, random);
            } else if (params instanceof LMSHSSKeyGenParameterSpec) {
                LMSKeyGenParameterSpec[] lmsParams = ((LMSHSSKeyGenParameterSpec)params).getLMSSpecs();
                FipsLMS.KeyParameters[] hssParams = new FipsLMS.KeyParameters[lmsParams.length];
                for (int i = 0; i != lmsParams.length; ++i) {
                    hssParams[i] = lmsParams[i].getKeyParams();
                }
                this.param = new FipsLMS.KeyGenParameters(hssParams);
                this.engine = new FipsLMS.KeyPairGenerator(this.param, random);
            } else {
                if (params == null) {
                    throw new InvalidAlgorithmParameterException("parameterSpec cannot be null");
                }
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + params.getClass().getName());
            }
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.param = new FipsLMS.KeyGenParameters(FipsLMS.lms_sha256_n32_h10.using(FipsLMS.sha256_n32_w4));
                if (this.random == null) {
                    this.random = this.provider.getDefaultSecureRandom();
                }
                this.engine = new FipsLMS.KeyPairGenerator(this.param, this.random);
                this.initialised = true;
            }
            AsymmetricKeyPair<AsymmetricLMSPublicKey, AsymmetricLMSPrivateKey> pair = this.engine.generateKeyPair();
            return new KeyPair(new ProvLMSPublicKey(pair.getPublicKey()), new ProvLMSPrivateKey(pair.getPrivateKey()));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class KeyFactorySpi
    extends BaseKeyFactory {
        String algorithm;

        public KeyFactorySpi(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                return new ProvLMSPublicKey((AsymmetricLMSPublicKey)lmsPublicKeyConverter.convertKey(FipsLMS.ALGORITHM, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                return new ProvLMSPrivateKey((AsymmetricLMSPrivateKey)lmsPrivateKeyConverter.convertKey(FipsLMS.ALGORITHM, (PrivateKey)key));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        @Override
        protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
            if (spec == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            return super.engineGetKeySpec(key, spec);
        }

        @Override
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            return super.engineGeneratePrivate(keySpec);
        }

        @Override
        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            return super.engineGeneratePublic(keySpec);
        }

        @Override
        public PrivateKey generatePrivate(PrivateKeyInfo keyInfo) throws IOException {
            ASN1ObjectIdentifier algOid = keyInfo.getPrivateKeyAlgorithm().getAlgorithm();
            if (algOid.equals(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig)) {
                return new ProvLMSPrivateKey(keyInfo);
            }
            throw new IOException("algorithm identifier " + algOid + " in key not recognized");
        }

        @Override
        public PublicKey generatePublic(SubjectPublicKeyInfo keyInfo) throws IOException {
            ASN1ObjectIdentifier algOid = keyInfo.getAlgorithm().getAlgorithm();
            if (algOid.equals(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig)) {
                return new ProvLMSPublicKey(keyInfo);
            }
            throw new IOException("algorithm identifier " + algOid + " in key not recognized");
        }
    }
}

