/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPublicKey;
import org.bouncycastle.jcajce.interfaces.EdDSAPublicKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvEdDSAPublicKey
implements EdDSAPublicKey {
    static final long serialVersionUID = 1L;
    private transient AsymmetricEdDSAPublicKey baseKey;

    ProvEdDSAPublicKey(AsymmetricEdDSAPublicKey pubKey) {
        this.baseKey = pubKey;
    }

    ProvEdDSAPublicKey(byte[] encoding) {
        this.baseKey = new AsymmetricEdDSAPublicKey(encoding);
    }

    @Override
    public String getAlgorithm() {
        return this.baseKey.getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getPublicData() {
        return this.baseKey.getPublicData();
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    public AsymmetricEdDSAPublicKey getBaseKey() {
        return this.baseKey;
    }

    public String toString() {
        return KeyUtil.keyToString("Public Key", this.getAlgorithm(), this.baseKey);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProvEdDSAPublicKey)) {
            return false;
        }
        ProvEdDSAPublicKey other = (ProvEdDSAPublicKey)o;
        return Arrays.areEqual(other.getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricEdDSAPublicKey(enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

