/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.crypto.AuthenticationParameters;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.MACOperatorFactory;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.SymmetricKeyGenerator;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.DES;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.params.DesParameters;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.AuthParametersCreator;
import org.bouncycastle.jcajce.provider.BaseCipher;
import org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import org.bouncycastle.jcajce.provider.BaseMac;
import org.bouncycastle.jcajce.provider.BaseSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.IVAlgorithmParameterGenerator;
import org.bouncycastle.jcajce.provider.IvAlgorithmParameters;
import org.bouncycastle.jcajce.provider.IvParametersCreator;
import org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import org.bouncycastle.jcajce.provider.MacParametersCreator;
import org.bouncycastle.jcajce.provider.PBEScheme;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import org.bouncycastle.jcajce.provider.ProvPBEPBKDF1;
import org.bouncycastle.jcajce.provider.ProvSecretKeySpec;
import org.bouncycastle.jcajce.provider.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ProvDES
extends AlgorithmProvider {
    private static final String PREFIX = ProvDES.class.getName();
    private Class[] availableSpecs = new Class[]{IvParameterSpec.class};
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(Parameters parameters) {
            if (Utils.isAuthMode(parameters.getAlgorithm())) {
                return new AuthParametersCreator((AuthenticationParametersWithIV)parameters);
            }
            return new IvParametersCreator((ParametersWithIV)parameters);
        }
    };

    ProvDES() {
    }

    @Override
    public void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("Cipher.DES", PREFIX + "$ECB", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseCipher.Builder(provider, 64, DES.ECBwithPKCS7, DES.ECB, DES.ECBwithISO10126_2, DES.ECBwithISO7816_4, DES.ECBwithTBC, DES.ECBwithX923, DES.CBC, DES.CBCwithPKCS7, DES.CBCwithISO10126_2, DES.CBCwithISO7816_4, DES.CBCwithTBC, DES.CBCwithX923, DES.CBCwithCS1, DES.CBCwithCS2, DES.CBCwithCS3, DES.CFB64, DES.CFB8, DES.OFB, DES.OpenPGPCFB, DES.CTR, DES.EAX).withFixedKeySize(64).withGeneralOperators(ProvDES.this.generalParametersCreatorProvider, new DES.OperatorFactory(), new DES.AEADOperatorFactory()).withParameters(ProvDES.this.availableSpecs).build();
            }
        }));
        provider.addAlgorithmImplementation("Cipher", OIWObjectIdentifiers.desCBC, PREFIX + "$CBC", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseCipher.Builder(provider, 64, DES.CBCwithPKCS7).withFixedKeySize(64).withGeneralOperators(ProvDES.this.generalParametersCreatorProvider, new DES.OperatorFactory(), null).withParameters(ProvDES.this.availableSpecs).build();
            }
        }));
        provider.addAlgorithmImplementation("KeyGenerator.DES", PREFIX + "$KeyGenerator", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseKeyGenerator(provider, "DES", 56, true, new KeyGeneratorCreator(){

                    @Override
                    public SymmetricKeyGenerator createInstance(int keySize, SecureRandom random) {
                        return new DES.KeyGenerator(random);
                    }
                });
            }
        }));
        provider.addAlias("KeyGenerator", "DES", "DEA");
        provider.addAlgorithmImplementation("SecretKeyFactory.DES", PREFIX + "$KeyFactory", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyFactory();
            }
        }));
        provider.addAlias("SecretKeyFactory", "DES", "DEA");
        provider.addAlgorithmImplementation("Mac.DESCMAC", PREFIX + "$CMAC", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseMac(DES.CMAC, (MACOperatorFactory)new DES.MACOperatorFactory(), new AuthParametersCreator(DES.CMAC));
            }
        }));
        provider.addAlgorithmImplementation("Mac.DESMAC", PREFIX + "$CBCMAC", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseMac(DES.CBC_MAC, (MACOperatorFactory)new DES.MACOperatorFactory(), new AuthParametersCreator(DES.CBC_MAC));
            }
        }));
        provider.addAlias("Alg.Alias.Mac.DES", "DESMAC");
        provider.addAlgorithmImplementation("Mac.DESMAC/CFB8", PREFIX + "$DESCFB8", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseMac(DES.CFB8_MAC, (MACOperatorFactory)new DES.MACOperatorFactory(), new AuthParametersCreator(DES.CFB8_MAC));
            }
        }));
        provider.addAlias("Alg.Alias.Mac.DES/CFB8", "DESMAC/CFB8");
        provider.addAlgorithmImplementation("Mac.DESMAC64", PREFIX + "$DES64", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseMac(DES.CBC_MAC, (MACOperatorFactory)new DES.MACOperatorFactory(), new MacParametersCreator(){

                    public AuthenticationParameters getBaseParameters() {
                        return DES.CBC_MAC.withMACSize(64);
                    }

                    public AuthenticationParameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
                        return DES.CBC_MAC.withMACSize(64);
                    }
                });
            }
        }));
        provider.addAlias("Alg.Alias.Mac.DES64", "DESMAC64");
        provider.addAlgorithmImplementation("Mac.DESMAC64WITHISO7816-4PADDING", PREFIX + "$DES64with7816d4", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseMac(DES.CBC_MACwithISO7816_4, (MACOperatorFactory)new DES.MACOperatorFactory(), new MacParametersCreator(){

                    public AuthenticationParameters getBaseParameters() {
                        return DES.CBC_MACwithISO7816_4.withMACSize(64);
                    }

                    public AuthenticationParameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
                        return DES.CBC_MACwithISO7816_4.withMACSize(64);
                    }
                });
            }
        }));
        provider.addAlias("Mac", "DESMAC64WITHISO7816-4PADDING", "DES64WITHISO7816-4PADDING");
        provider.addAlias("Mac", "DESMAC64WITHISO7816-4PADDING", "DESISO9797ALG1MACWITHISO7816-4PADDING");
        provider.addAlias("Mac", "DESMAC64WITHISO7816-4PADDING", "DESISO9797ALG1WITHISO7816-4PADDING");
        provider.addAlgorithmImplementation("Mac.DESWITHISO9797", PREFIX + "$DES9797Alg3", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseMac(DES.ISO9797alg3Mac, (MACOperatorFactory)new DES.MACOperatorFactory(), new MacParametersCreator(){

                    public AuthenticationParameters getBaseParameters() {
                        return DES.ISO9797alg3Mac;
                    }

                    public AuthenticationParameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
                        return DES.ISO9797alg3Mac;
                    }
                });
            }
        }));
        provider.addAlias("Mac", "DESWITHISO9797", "DESISO9797MAC", "ISO9797ALG3", "ISO9797ALG3MAC");
        provider.addAlgorithmImplementation("Mac.ISO9797ALG3WITHISO7816-4PADDING", PREFIX + "$DES9797Alg3with7816d4", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseMac(DES.ISO9797alg3MACwithISO7816_4, (MACOperatorFactory)new DES.MACOperatorFactory(), new MacParametersCreator(){

                    public AuthenticationParameters getBaseParameters() {
                        return DES.ISO9797alg3MACwithISO7816_4.withMACSize(64);
                    }

                    public AuthenticationParameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
                        return DES.ISO9797alg3MACwithISO7816_4.withMACSize(64);
                    }
                });
            }
        }));
        provider.addAlias("Alg.Alias.Mac.ISO9797ALG3MACWITHISO7816-4PADDING", "ISO9797ALG3WITHISO7816-4PADDING");
        provider.addAlgorithmImplementation("AlgorithmParameters.DES", PREFIX + ".util.IvAlgorithmParameters", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new IvAlgorithmParameters();
            }
        }));
        provider.addAlias("AlgorithmParameters", "DES", OIWObjectIdentifiers.desCBC);
        provider.addAlgorithmImplementation("AlgorithmParameterGenerator", OIWObjectIdentifiers.desCBC, PREFIX + "$AlgParamGen", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new IVAlgorithmParameterGenerator(provider, "DES", 8);
            }
        }));
        provider.addAlgorithmImplementation("Cipher.PBEWITHMD5ANDDES-CBC", PREFIX + "$PBEWithMD5", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseCipher.Builder(provider, 64, DES.CBCwithPKCS7).withGeneralOperators(ProvDES.this.generalParametersCreatorProvider, new DES.OperatorFactory(), null).withFixedKeySize(64).withScheme(PBEScheme.PBKDF1).withPrf(SecureHash.Algorithm.MD5).withParameters(ProvDES.this.availableSpecs).build();
            }
        }));
        provider.addAlgorithmImplementation("Cipher.PBEWITHSHA1ANDDES-CBC", PREFIX + "$PBEWithSHA1", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseCipher.Builder(provider, 64, DES.CBCwithPKCS7).withGeneralOperators(ProvDES.this.generalParametersCreatorProvider, new DES.OperatorFactory(), null).withFixedKeySize(64).withScheme(PBEScheme.PBKDF1).withPrf(FipsSHS.Algorithm.SHA1).withParameters(ProvDES.this.availableSpecs).build();
            }
        }));
        provider.addAlias("Cipher", "PBEWITHMD5ANDDES-CBC", "PBEWITHMD5ANDDES");
        provider.addAlias("Cipher", "PBEWITHSHA1ANDDES-CBC", "PBEWITHSHA1ANDDES");
        provider.addAlias("Cipher", "PBEWITHMD5ANDDES-CBC", PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC);
        provider.addAlias("Cipher", "PBEWITHSHA1ANDDES-CBC", PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC);
        provider.addAlgorithmImplementation("SecretKeyFactory.PBEWITHSHAANDDES", PREFIX + "PBESHADES", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new ProvPBEPBKDF1.FixedPBKDF1("DES", PasswordConverter.ASCII, FipsSHS.Algorithm.SHA1, 64);
            }
        }));
        provider.addAlias("SecretKeyFactory", "PBEWITHSHAANDDES", "PBEWITHSHA1ANDDES", "PBEWITHSHA-1ANDDES");
        provider.addAlgorithmImplementation("SecretKeyFactory.PBEWITHMD5ANDDES", PREFIX + "PBEMD5DES", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new ProvPBEPBKDF1.FixedPBKDF1("DES", PasswordConverter.ASCII, SecureHash.Algorithm.MD5, 64);
            }
        }));
        this.addAlias(provider, OIWObjectIdentifiers.desCBC, "DES");
    }

    private void addAlias(BouncyCastleFipsProvider provider, ASN1ObjectIdentifier oid, String name) {
        provider.addAlias("KeyGenerator", name, oid);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class KeyFactory
    extends BaseSecretKeyFactory {
        KeyFactory() {
            super("DES", DES.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                @Override
                public byte[] validated(byte[] keyBytes) throws InvalidKeySpecException {
                    int size = keyBytes.length * 8;
                    if (size != 64) {
                        throw new InvalidKeySpecException("Provided key data wrong size for DES");
                    }
                    DesParameters.setOddParity(keyBytes);
                    return keyBytes;
                }
            });
        }

        @Override
        protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
            if (keySpec == null) {
                throw new InvalidKeySpecException("keySpec parameter is null");
            }
            if (key == null) {
                throw new InvalidKeySpecException("key parameter is null");
            }
            if (DESKeySpec.class.isAssignableFrom(keySpec)) {
                try {
                    return new DESKeySpec(this.validator.validated(key.getEncoded()));
                }
                catch (InvalidKeyException e) {
                    throw new InvalidKeySpecException(e.getMessage(), e);
                }
            }
            return super.engineGetKeySpec(key, keySpec);
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DESKeySpec) {
                DESKeySpec desKeySpec = (DESKeySpec)keySpec;
                return new ProvSecretKeySpec(new ValidatedSymmetricKey(DES.ALGORITHM, this.validator.validated(desKeySpec.getKey())));
            }
            return super.engineGenerateSecret(keySpec);
        }
    }
}

