/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.SymmetricKeyGenerator;
import org.bouncycastle.crypto.general.ARC4;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseCipher;
import org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import org.bouncycastle.jcajce.provider.BaseSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import org.bouncycastle.jcajce.provider.PBEScheme;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import org.bouncycastle.jcajce.provider.ProvPKCS12;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ProvARC4
extends AlgorithmProvider {
    private static final String PREFIX = ProvARC4.class.getName();
    private ParametersCreator parametersCreator = new ParametersCreator(){

        public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) {
            return ARC4.STREAM;
        }
    };
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(Parameters parameters) {
            return ProvARC4.this.parametersCreator;
        }
    };

    ProvARC4() {
    }

    @Override
    public void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("Cipher.ARC4", PREFIX + "$Base", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseCipher.Builder(provider, 0, ARC4.STREAM).withParameters(new Class[0]).withGeneralOperators(ProvARC4.this.generalParametersCreatorProvider, new ARC4.OperatorFactory(), null).build();
            }
        }));
        provider.addAlias("Cipher", "ARC4", PKCSObjectIdentifiers.rc4);
        provider.addAlias("Alg.Alias.Cipher.ARCFOUR", "ARC4");
        provider.addAlias("Alg.Alias.Cipher.RC4", "ARC4");
        provider.addAlgorithmImplementation("KeyGenerator.ARC4", PREFIX + "$KeyGen", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseKeyGenerator(provider, "RC4", 128, new KeyGeneratorCreator(){

                    @Override
                    public SymmetricKeyGenerator createInstance(int keySize, SecureRandom random) {
                        return new ARC4.KeyGenerator(keySize, random);
                    }
                });
            }
        }));
        provider.addAlias("Alg.Alias.KeyGenerator.RC4", "ARC4");
        provider.addAlias("KeyGenerator", "ARC4", PKCSObjectIdentifiers.rc4);
        provider.addAlgorithmImplementation("Cipher.PBEWITHSHAAND40BITRC4", PREFIX + "$PBEWithSHAAnd40BitKeyFactory", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseCipher.Builder(provider, 0, ARC4.STREAM).withFixedKeySize(40).withScheme(PBEScheme.PKCS12).withGeneralOperators(ProvARC4.this.generalParametersCreatorProvider, new ARC4.OperatorFactory(), null).withParameters(new Class[]{PBEParameterSpec.class}).build();
            }
        }));
        provider.addAlias("Cipher", "PBEWITHSHAAND40BITRC4", PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC4);
        provider.addAlgorithmImplementation("Cipher.PBEWITHSHAAND128BITRC4", PREFIX + "$PBEWithSHAAnd128BitKeyFactory", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseCipher.Builder(provider, 0, ARC4.STREAM).withFixedKeySize(128).withScheme(PBEScheme.PKCS12).withGeneralOperators(ProvARC4.this.generalParametersCreatorProvider, new ARC4.OperatorFactory(), null).withParameters(new Class[]{PBEParameterSpec.class}).build();
            }
        }));
        provider.addAlias("Cipher", "PBEWITHSHAAND128BITRC4", PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4);
        provider.addAlgorithmImplementation("SecretKeyFactory.ARC4", PREFIX + "$ARC4KFACT", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseSecretKeyFactory("RC4", ARC4.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                    @Override
                    public byte[] validated(byte[] keyBytes) throws InvalidKeySpecException {
                        int size = keyBytes.length * 8;
                        if (size < 8 || size > 1024) {
                            throw new InvalidKeySpecException("Provided key data wrong size for ARC4");
                        }
                        return keyBytes;
                    }
                });
            }
        }));
        provider.addAlias("SecretKeyFactory", "ARC4", "RC4");
        provider.addAlgorithmImplementation("SecretKeyFactory.PBEWITHSHAAND128BITRC4", PREFIX + "PBE128RC4", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new ProvPKCS12.KeyFactory("RC4", PasswordBasedDeriver.KeyType.CIPHER, 128);
            }
        }));
        provider.addAlias("SecretKeyFactory", "PBEWITHSHAAND128BITRC4", "PBEWITHSHA1AND128BITRC4", "PBEWITHSHA-1AND128BITRC4");
        provider.addAlgorithmImplementation("SecretKeyFactory.PBEWITHSHAAND40BITRC4", PREFIX + "PBE40RC4", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new ProvPKCS12.KeyFactory("RC4", PasswordBasedDeriver.KeyType.CIPHER, 40);
            }
        }));
        provider.addAlias("SecretKeyFactory", "PBEWITHSHAAND40BITRC4", "PBEWITHSHA1AND40BITRC4", "PBEWITHSHA-1AND40BITRC4");
        provider.addAlias("AlgorithmParameters", "PBKDF-PKCS12", PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC4, PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4);
    }
}

