/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.internal.asn1.cms.GCMParameters;
import org.bouncycastle.jcajce.provider.ClassUtil;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.util.Integers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class GcmSpecUtil {
    static final Class gcmSpecClass = ClassUtil.lookup("javax.crypto.spec.GCMParameterSpec");
    static final Method tLen;
    static final Method iv;

    GcmSpecUtil() {
    }

    static boolean gcmSpecExists() {
        return gcmSpecClass != null;
    }

    static boolean isGcmSpec(AlgorithmParameterSpec paramSpec) {
        return gcmSpecClass != null && gcmSpecClass.isInstance(paramSpec);
    }

    static boolean isGcmSpec(Class paramSpecClass) {
        return gcmSpecClass == paramSpecClass;
    }

    static Class[] getCipherSpecClasses() {
        if (GcmSpecUtil.gcmSpecExists()) {
            return new Class[]{gcmSpecClass, IvParameterSpec.class};
        }
        return new Class[]{AEADParameterSpec.class, IvParameterSpec.class};
    }

    static AlgorithmParameterSpec extractGcmSpec(final ASN1Primitive spec) throws InvalidParameterSpecException {
        Object rv = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    GCMParameters gcmParams = GCMParameters.getInstance(spec);
                    Constructor constructor = gcmSpecClass.getConstructor(Integer.TYPE, byte[].class);
                    return constructor.newInstance(Integers.valueOf(gcmParams.getIcvLen() * 8), gcmParams.getNonce());
                }
                catch (NoSuchMethodException e) {
                    return new InvalidParameterSpecException("no constructor found!");
                }
                catch (Exception e) {
                    return new InvalidParameterSpecException("construction failed: " + e.getMessage());
                }
            }
        });
        if (rv instanceof AlgorithmParameterSpec) {
            return (AlgorithmParameterSpec)rv;
        }
        throw (InvalidParameterSpecException)rv;
    }

    static GCMParameters extractGcmParameters(final AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        Object rv = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return new GCMParameters((byte[])iv.invoke((Object)paramSpec, new Object[0]), (Integer)tLen.invoke((Object)paramSpec, new Object[0]) / 8);
                }
                catch (Exception e) {
                    return new InvalidParameterSpecException("cannot process GCMParameterSpec: " + e.getMessage());
                }
            }
        });
        if (rv instanceof GCMParameters) {
            return (GCMParameters)rv;
        }
        throw (InvalidParameterSpecException)rv;
    }

    static {
        if (gcmSpecClass != null) {
            tLen = ClassUtil.extractMethod(gcmSpecClass, "getTLen");
            iv = ClassUtil.extractMethod(gcmSpecClass, "getIV");
        } else {
            tLen = null;
            iv = null;
        }
    }
}

