/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util.dispose;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.crypto.util.dispose.Disposable;
import org.bouncycastle.util.Properties;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DisposalDaemon
implements Runnable {
    private static final Logger LOG = Logger.getLogger(DisposalDaemon.class.getName());
    private static final ReferenceQueue<Disposable> referenceQueue = new ReferenceQueue();
    private static final Set<ReferenceWrapperWithDisposerRunnable> refs = ConcurrentHashMap.newKeySet();
    private static final ScheduledExecutorService cleanupExecutor;
    private static final DisposalDaemon disposalDaemon;
    private static final Thread disposalThread;
    private static final long cleanupDelayMillis;
    private static final String CLEANUP_DELAY_PROP = "org.bouncycastle.native.cleanup_delay";
    private static final String DISPOSAL_DAEMON_PRIORITY = "org.bouncycastle.native.cleanup_priority";

    private static void addShutdownHook() {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ReferenceWrapperWithDisposerRunnable item = (ReferenceWrapperWithDisposerRunnable)referenceQueue.poll();
                    while (item != null) {
                        refs.remove(item);
                        item.dispose();
                        item = (ReferenceWrapperWithDisposerRunnable)referenceQueue.poll();
                    }
                }
            });
        }
        catch (Throwable t) {
            LOG.warning("adding shutdown hook: " + t.getMessage());
        }
    }

    public static void addDisposable(Disposable disposable) {
        ReferenceWrapperWithDisposerRunnable ref = new ReferenceWrapperWithDisposerRunnable(disposable, referenceQueue);
        refs.add(ref);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    final ReferenceWrapperWithDisposerRunnable item = (ReferenceWrapperWithDisposerRunnable)referenceQueue.remove();
                    refs.remove(item);
                    if (cleanupExecutor == null) {
                        item.dispose();
                        continue;
                    }
                    cleanupExecutor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            item.dispose();
                        }
                    }, cleanupDelayMillis, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException iex) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (Throwable e) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("exception in disposal thread: " + e.getMessage());
                continue;
            }
            break;
        }
    }

    static {
        disposalDaemon = new DisposalDaemon();
        String delayProp = Properties.getPropertyValue(CLEANUP_DELAY_PROP, "0").trim();
        if (delayProp.endsWith("ms")) {
            delayProp = delayProp.replace("ms", "").trim();
            cleanupDelayMillis = Long.parseLong(delayProp);
        } else {
            cleanupDelayMillis = Long.parseLong(delayProp) * 1000L;
        }
        cleanupExecutor = cleanupDelayMillis > 0L ? Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "BC Cleanup Executor");
                t.setDaemon(true);
                return t;
            }
        }) : null;
        String ddPriority = Properties.getPropertyValue(DISPOSAL_DAEMON_PRIORITY, "min").trim();
        disposalThread = new Thread((Runnable)disposalDaemon, "BC Disposal Daemon");
        disposalThread.setDaemon(true);
        if ("min".equals(ddPriority)) {
            disposalThread.setPriority(1);
        } else if ("normal".equals(ddPriority)) {
            disposalThread.setPriority(5);
        } else if ("high".equals(ddPriority)) {
            disposalThread.setPriority(10);
        } else {
            throw new IllegalArgumentException("Unknown disposal daemon priority: " + ddPriority);
        }
        disposalThread.start();
        DisposalDaemon.addShutdownHook();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class ReferenceWrapperWithDisposerRunnable
    extends PhantomReference<Disposable> {
        private final Runnable disposer;
        private final String label;

        public ReferenceWrapperWithDisposerRunnable(Disposable referent, ReferenceQueue<? super Disposable> q) {
            super(referent, q);
            this.disposer = referent.getDisposeAction();
            this.label = referent.toString();
        }

        public void dispose() {
            this.disposer.run();
        }

        public String toString() {
            return this.label;
        }
    }
}

