/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.wrappers;

import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.Wrapper;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class SP80038FWrapper
implements Wrapper {
    protected static final byte[] ivKW = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
    protected static final byte[] ivKWP = new byte[]{-90, 89, 89, -90};
    protected final boolean wrapCipherMode;
    protected final BlockCipher engine;
    protected final int delta;
    protected final byte[] iv;
    protected KeyParameter param;
    protected boolean forWrapping;

    protected SP80038FWrapper(BlockCipher engine, byte[] iv, boolean useReverseDirection) {
        this.engine = engine;
        this.wrapCipherMode = !useReverseDirection;
        this.delta = engine.getBlockSize() / 2;
        this.iv = new byte[iv.length > this.delta ? this.delta : iv.length];
        System.arraycopy(iv, 0, this.iv, 0, this.iv.length);
    }

    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        this.forWrapping = forWrapping;
        if (param instanceof KeyParameter) {
            this.param = (KeyParameter)param;
        } else if (param instanceof ParametersWithIV) {
            byte[] newIv = ((ParametersWithIV)param).getIV();
            if (newIv.length != this.iv.length) {
                throw new IllegalArgumentException("IV not equal to " + ivKWP.length);
            }
            this.param = (KeyParameter)((ParametersWithIV)param).getParameters();
            System.arraycopy(newIv, 0, this.iv, 0, this.iv.length);
        }
    }

    protected byte[] W(int n, byte[] block) {
        byte[] buf = new byte[this.engine.getBlockSize()];
        this.engine.init(this.wrapCipherMode, this.param);
        for (int j = 0; j != 6; ++j) {
            for (int i = 1; i <= n; ++i) {
                System.arraycopy(block, 0, buf, 0, this.delta);
                System.arraycopy(block, this.delta * i, buf, this.delta, this.delta);
                this.engine.processBlock(buf, 0, buf, 0);
                int t = n * j + i;
                int k = 1;
                while (t != 0) {
                    byte v = (byte)t;
                    int n2 = this.delta - k;
                    buf[n2] = (byte)(buf[n2] ^ v);
                    t >>>= 8;
                    ++k;
                }
                System.arraycopy(buf, 0, block, 0, this.delta);
                System.arraycopy(buf, this.delta, block, this.delta * i, this.delta);
            }
        }
        return block;
    }

    protected void invW(int n, byte[] block, byte[] a) {
        byte[] buf = new byte[this.engine.getBlockSize()];
        this.engine.init(!this.wrapCipherMode, this.param);
        --n;
        for (int j = 5; j >= 0; --j) {
            for (int i = n; i >= 1; --i) {
                System.arraycopy(a, 0, buf, 0, this.delta);
                System.arraycopy(block, this.delta * (i - 1), buf, this.delta, this.delta);
                int t = n * j + i;
                int k = 1;
                while (t != 0) {
                    byte v = (byte)t;
                    int n2 = this.delta - k;
                    buf[n2] = (byte)(buf[n2] ^ v);
                    t >>>= 8;
                    ++k;
                }
                this.engine.processBlock(buf, 0, buf, 0);
                System.arraycopy(buf, 0, a, 0, this.delta);
                System.arraycopy(buf, this.delta, block, this.delta * (i - 1), this.delta);
            }
        }
    }
}

