/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.params;

import org.bouncycastle.crypto.internal.DerivationParameters;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class HKDFParameters
implements DerivationParameters {
    private final KeyParameter hkdfKey;
    private final byte[] info;

    public HKDFParameters(KeyParameter hkdfKey, byte[] info) {
        if (hkdfKey == null) {
            throw new IllegalArgumentException("hkdfKey (input keying material) should not be null");
        }
        this.hkdfKey = hkdfKey;
        this.info = info == null ? new byte[0] : Arrays.clone(info);
    }

    public KeyParameter getKey() {
        return this.hkdfKey;
    }

    public byte[] getInfo() {
        return Arrays.clone(this.info);
    }
}

