/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.params;

import java.math.BigInteger;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.params.DsaValidationParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DsaParameters
implements CipherParameters {
    private BigInteger g;
    private BigInteger q;
    private BigInteger p;
    private DsaValidationParameters validation;

    public DsaParameters(BigInteger p, BigInteger q, BigInteger g) {
        this.g = g;
        this.p = p;
        this.q = q;
    }

    public DsaParameters(BigInteger p, BigInteger q, BigInteger g, DsaValidationParameters params) {
        this.g = g;
        this.p = p;
        this.q = q;
        this.validation = params;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getG() {
        return this.g;
    }

    public DsaValidationParameters getValidationParameters() {
        return this.validation;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DsaParameters)) {
            return false;
        }
        DsaParameters pm = (DsaParameters)obj;
        return pm.getP().equals(this.p) && pm.getQ().equals(this.q) && pm.getG().equals(this.g);
    }

    public int hashCode() {
        return this.getP().hashCode() ^ this.getQ().hashCode() ^ this.getG().hashCode();
    }
}

