/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.params;

import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.params.DhPublicKeyParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DhuPublicParameters
implements CipherParameters {
    private DhPublicKeyParameters staticPublicKey;
    private DhPublicKeyParameters ephemeralPublicKey;

    public DhuPublicParameters(DhPublicKeyParameters staticPublicKey, DhPublicKeyParameters ephemeralPublicKey) {
        this.staticPublicKey = staticPublicKey;
        this.ephemeralPublicKey = ephemeralPublicKey;
        if (!staticPublicKey.getParameters().equals(ephemeralPublicKey.getParameters())) {
            throw new IllegalKeyException("Static and ephemeral keys have different domain parameters");
        }
    }

    public DhPublicKeyParameters getStaticPublicKey() {
        return this.staticPublicKey;
    }

    public DhPublicKeyParameters getEphemeralPublicKey() {
        return this.ephemeralPublicKey;
    }
}

