/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.params;

import java.math.BigInteger;
import org.bouncycastle.crypto.internal.CipherParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DhParameters
implements CipherParameters {
    private static final int DEFAULT_MINIMUM_LENGTH = 160;
    private final BigInteger g;
    private final BigInteger p;
    private final BigInteger q;
    private final BigInteger j;
    private final int m;
    private final int l;

    private static int getDefaultMParam(int lParam) {
        if (lParam == 0) {
            return 160;
        }
        return lParam < 160 ? lParam : 160;
    }

    public DhParameters(BigInteger p, BigInteger g, BigInteger q) {
        this(p, g, q, DhParameters.getDefaultMParam(0), 0, null);
    }

    public DhParameters(BigInteger p, BigInteger g, BigInteger q, BigInteger j) {
        this(p, g, q, 160, 0, j);
    }

    public DhParameters(BigInteger p, BigInteger g, BigInteger q, int m, int l, BigInteger j) {
        if (l != 0) {
            if (l > p.bitLength()) {
                throw new IllegalArgumentException("when l value specified, it must satisfy 2^(l-1) <= p");
            }
            if (l < m) {
                throw new IllegalArgumentException("when l value specified, it may not be less than m value");
            }
        }
        this.g = g;
        this.p = p;
        this.q = q;
        this.m = m;
        this.l = l;
        this.j = j;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getJ() {
        return this.j;
    }

    public int getM() {
        return this.m;
    }

    public int getL() {
        return this.l;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DhParameters) {
            DhParameters pm = (DhParameters)obj;
            if (this.getQ() != null ? !this.getQ().equals(pm.getQ()) : pm.getQ() != null) {
                return false;
            }
            return pm.getP().equals(this.p) && pm.getG().equals(this.g);
        }
        return false;
    }

    public int hashCode() {
        int hc = this.getP().hashCode();
        hc += 37 * this.getG().hashCode();
        return hc += 37 * (this.getQ() != null ? this.getQ().hashCode() : 0);
    }
}

