/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.io;

import java.io.IOException;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.io.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DigestOutputStream
extends UpdateOutputStream {
    private final String algorithmName;
    private final boolean isApprovedMode;
    protected Digest digest;

    public DigestOutputStream(Digest digest) {
        this.algorithmName = digest.getAlgorithmName();
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.digest = digest;
    }

    @Override
    public void write(int b) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.update((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.update(b, off, len);
    }

    public final byte[] getDigest() {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        byte[] res = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(res, 0);
        return res;
    }
}

