/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.encodings;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.internal.AsymmetricBlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PKCS1Encoding
implements AsymmetricBlockCipher {
    public static final String NOT_STRICT_LENGTH_ENABLED_PROPERTY = "org.bouncycastle.pkcs1.not_strict";
    private static final int HEADER_LENGTH = 10;
    private SecureRandom random;
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private boolean forPrivateKey;
    private boolean useStrictLength;
    private byte[] dudBlock;

    public PKCS1Encoding(AsymmetricBlockCipher cipher) {
        this.engine = cipher;
        this.useStrictLength = this.useStrict();
    }

    private boolean useStrict() {
        return CryptoServicesRegistrar.isInApprovedOnlyMode() || !Properties.isOverrideSet(NOT_STRICT_LENGTH_ENABLED_PROPERTY);
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        AsymmetricKeyParameter kParam;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.random = rParam.getRandom();
            kParam = (AsymmetricKeyParameter)rParam.getParameters();
        } else {
            kParam = (AsymmetricKeyParameter)param;
            if (!kParam.isPrivate() && forEncryption) {
                throw new IllegalArgumentException("No SecureRandom specified.");
            }
        }
        this.engine.init(forEncryption, param);
        this.forPrivateKey = kParam.isPrivate();
        this.forEncryption = forEncryption;
        this.dudBlock = new byte[this.engine.getOutputBlockSize()];
    }

    @Override
    public int getInputBlockSize() {
        int baseBlockSize = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize - 10;
        }
        return baseBlockSize;
    }

    @Override
    public int getOutputBlockSize() {
        int baseBlockSize = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize;
        }
        return baseBlockSize - 10;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(in, inOff, inLen);
        }
        return this.decodeBlock(in, inOff, inLen);
    }

    private byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (inLen > this.getInputBlockSize()) {
            throw new IllegalArgumentException("input data too large");
        }
        byte[] block = new byte[this.engine.getInputBlockSize()];
        if (this.forPrivateKey) {
            block[0] = 1;
            for (int i = 1; i != block.length - inLen - 1; ++i) {
                block[i] = -1;
            }
        } else {
            this.random.nextBytes(block);
            block[0] = 2;
            for (int i = 1; i != block.length - inLen - 1; ++i) {
                while (block[i] == 0) {
                    block[i] = (byte)this.random.nextInt();
                }
            }
        }
        block[block.length - inLen - 1] = 0;
        System.arraycopy(in, inOff, block, block.length - inLen, inLen);
        return this.engine.processBlock(block, 0, block.length);
    }

    private byte[] decodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] block = this.engine.processBlock(in, inOff, inLen);
        if (block.length < this.getOutputBlockSize()) {
            block = this.dudBlock;
        }
        byte type = block[0];
        boolean badType = this.forPrivateKey ? type != 2 : type != 1;
        boolean incorrectLength = this.useStrictLength & block.length != this.engine.getOutputBlockSize();
        int start = this.findStart(type, block);
        if (badType | ++start < 10) {
            Arrays.fill(block, (byte)0);
            throw new InvalidCipherTextException("block incorrect");
        }
        if (incorrectLength) {
            Arrays.fill(block, (byte)0);
            throw new InvalidCipherTextException("block incorrect size");
        }
        byte[] result = new byte[block.length - start];
        System.arraycopy(block, start, result, 0, result.length);
        return result;
    }

    private int findStart(byte type, byte[] block) throws InvalidCipherTextException {
        int start = -1;
        boolean padErr = false;
        for (int i = 1; i != block.length; ++i) {
            byte pad = block[i];
            if (pad == 0 & start < 0) {
                start = i;
            }
            padErr |= type == 1 & start < 0 & pad != -1;
        }
        if (padErr) {
            return -1;
        }
        return start;
    }
}

