/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.OutputSigner;
import org.bouncycastle.crypto.OutputValidator;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.crypto.fips.FipsEC;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.DSAOutputSigner;
import org.bouncycastle.crypto.general.DSAOutputValidator;
import org.bouncycastle.crypto.general.DSAOutputVerifier;
import org.bouncycastle.crypto.general.EcDsaSigner;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.general.GuardedSignatureOperatorFactory;
import org.bouncycastle.crypto.general.HMacDsaKCalculator;
import org.bouncycastle.crypto.general.NullDigest;
import org.bouncycastle.crypto.general.RandomDsaKCalculator;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.params.EcDomainParameters;
import org.bouncycastle.crypto.internal.params.EcNamedDomainParameters;
import org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.util.Properties;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class EC {
    public static final Algorithm ALGORITHM = FipsEC.ALGORITHM;
    public static final DSAParameters DSA = new DSAParameters(new GeneralAlgorithm(ALGORITHM.getName(), (Enum)Variations.ECDSA), FipsSHS.Algorithm.SHA1);
    public static final DSAParameters DDSA = new DSAParameters(new GeneralAlgorithm(ALGORITHM.getName(), (Enum)Variations.ECDDSA), FipsSHS.Algorithm.SHA1);

    private EC() {
    }

    private static void checkEnabled() {
        if (Properties.isOverrideSet("org.bouncycastle.ec.disable")) {
            throw new UnsupportedOperationException("EC has been disabled by setting \"org.bouncycastle.ec.disable\"");
        }
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters curveParams) {
        if (curveParams instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters((NamedECDomainParameters)curveParams);
        }
        return new EcDomainParameters(curveParams);
    }

    private static EcPrivateKeyParameters getLwKey(final AsymmetricECPrivateKey privKey) {
        return AccessController.doPrivileged(new PrivilegedAction<EcPrivateKeyParameters>(){

            @Override
            public EcPrivateKeyParameters run() {
                return new EcPrivateKeyParameters(privKey.getS(), EC.getDomainParams(privKey.getDomainParameters()));
            }
        });
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class DSAOperatorFactory
    extends GuardedSignatureOperatorFactory<DSAParameters> {
        public DSAOperatorFactory() {
            EC.checkEnabled();
        }

        @Override
        protected OutputSigner<DSAParameters> doCreateSigner(AsymmetricPrivateKey key, DSAParameters parameters) {
            AsymmetricECPrivateKey k = (AsymmetricECPrivateKey)key;
            Digest digest = parameters.digestAlgorithm != null ? Register.createDigest(parameters.digestAlgorithm) : new NullDigest();
            EcDsaSigner ecdsaSigner = ((GeneralAlgorithm)parameters.getAlgorithm()).basicVariation() == ((GeneralAlgorithm)DSA.getAlgorithm()).basicVariation() ? new EcDsaSigner(new RandomDsaKCalculator()) : new EcDsaSigner(new HMacDsaKCalculator(Register.createDigest(parameters.digestAlgorithm)));
            final EcPrivateKeyParameters privateKeyParameters = EC.getLwKey(k);
            return new DSAOutputSigner<DSAParameters>(ecdsaSigner, digest, parameters, new DSAOutputSigner.Initializer(){

                @Override
                public void initialize(DSA signer, SecureRandom random) {
                    signer.init(true, new ParametersWithRandom(privateKeyParameters, random));
                }
            });
        }

        @Override
        protected OutputVerifier<DSAParameters> doCreateVerifier(AsymmetricPublicKey key, DSAParameters parameters) {
            EcDsaSigner ecdsaSigner = new EcDsaSigner();
            Digest digest = parameters.digestAlgorithm != null ? Register.createDigest(parameters.digestAlgorithm) : new NullDigest();
            AsymmetricECPublicKey k = (AsymmetricECPublicKey)key;
            EcPublicKeyParameters publicKeyParameters = new EcPublicKeyParameters(k.getW(), EC.getDomainParams(k.getDomainParameters()));
            ecdsaSigner.init(false, publicKeyParameters);
            return new DSAOutputVerifier<DSAParameters>(ecdsaSigner, digest, parameters);
        }

        @Override
        protected OutputValidator<DSAParameters> doCreateValidator(AsymmetricPublicKey key, DSAParameters parameters, byte[] signature) throws InvalidSignatureException {
            EcDsaSigner ecdsaSigner = new EcDsaSigner();
            Digest digest = parameters.digestAlgorithm != null ? Register.createDigest(parameters.digestAlgorithm) : new NullDigest();
            AsymmetricECPublicKey k = (AsymmetricECPublicKey)key;
            EcPublicKeyParameters publicKeyParameters = new EcPublicKeyParameters(k.getW(), EC.getDomainParams(k.getDomainParameters()));
            ecdsaSigner.init(false, publicKeyParameters);
            return new DSAOutputValidator<DSAParameters>(ecdsaSigner, digest, parameters, signature);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator {
        private final FipsEC.KeyPairGenerator kpGen;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom random) {
            super(keyGenParameters);
            EC.checkEnabled();
            this.kpGen = new FipsEC.KeyPairGenerator(new FipsEC.KeyGenParameters(keyGenParameters.domainParameters), random);
        }

        protected AsymmetricKeyPair doGenerateKeyPair() {
            AsymmetricKeyPair<AsymmetricECPublicKey, AsymmetricECPrivateKey> kp = this.kpGen.generateKeyPair();
            final Algorithm algorithm = this.getParameters().getAlgorithm();
            final AsymmetricECPublicKey pubK = kp.getPublicKey();
            final AsymmetricECPrivateKey priK = kp.getPrivateKey();
            return AccessController.doPrivileged(new PrivilegedAction<AsymmetricKeyPair>(){

                @Override
                public AsymmetricKeyPair run() {
                    return new AsymmetricKeyPair<AsymmetricECPublicKey, AsymmetricECPrivateKey>(new AsymmetricECPublicKey(algorithm, pubK.getDomainParameters(), pubK.getW()), new AsymmetricECPrivateKey(algorithm, priK.getDomainParameters(), priK.getS(), pubK.getW()));
                }
            });
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class DSAParameters
    extends GeneralParameters<GeneralAlgorithm> {
        private final DigestAlgorithm digestAlgorithm;

        DSAParameters(GeneralAlgorithm type, DigestAlgorithm digestAlgorithm) {
            super(type);
            if (type.basicVariation() == Variations.ECDDSA && digestAlgorithm == null) {
                throw new IllegalArgumentException("ECDDSA cannot be used with a NULL digest");
            }
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public DSAParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new DSAParameters((GeneralAlgorithm)this.getAlgorithm(), digestAlgorithm);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class KeyGenParameters
    extends GeneralParameters {
        private final ECDomainParameters domainParameters;

        public KeyGenParameters(ECDomainParameters domainParameters) {
            this(ALGORITHM, domainParameters);
        }

        public KeyGenParameters(DSAParameters parameters, ECDomainParameters domainParameters) {
            this((Algorithm)parameters.getAlgorithm(), domainParameters);
        }

        private KeyGenParameters(Algorithm algorithm, ECDomainParameters domainParameters) {
            super(algorithm);
            this.domainParameters = domainParameters;
        }

        public ECDomainParameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum Variations {
        ECDSA,
        ECDDSA;

    }
}

